/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.web.authentication.credentials.CredentialsFunctionHandler;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class LoginQuestionHandler
extends CredentialsFunctionHandler {
    @Override
    public String getFunction() {
        return "LoginQuestion";
    }

    @Override
    public String doAction(HttpServletRequest request) {
        String login = request.getParameter("Login");
        String domainId = request.getParameter("DomainId");
        try {
            String userId = this.getAdminService().getUserIdByLoginAndDomain(login, domainId);
            UserDetail userDetail = UserDetail.getById((String)userId);
            if (StringUtil.isDefined((String)userDetail.getLoginQuestion())) {
                request.setAttribute("userDetail", (Object)userDetail);
                request.setAttribute("userLanguage", (Object)userDetail.getUserPreferences().getLanguage());
                return this.getGeneral().getString("userLoginQuestionPage");
            }
            return "/Login?ErrorCode=2";
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error("login question error with login {0}", (Object[])new String[]{login}, (Throwable)e);
            return "/Login?ErrorCode=2";
        }
    }
}

