/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.web.authentication.credentials.ChangePasswordFunctionHandler;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class EffectiveChangePasswordBeforeExpirationHandler
extends ChangePasswordFunctionHandler {
    @Override
    public String getFunction() {
        return "EffectiveChangePasswordBeforeExpiration";
    }

    @Override
    public String doAction(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        MainSessionController controller = (MainSessionController)session.getAttribute("SilverSessionController");
        if (controller == null) {
            return "/Login";
        }
        UserDetail ud = controller.getCurrentUserDetail();
        try {
            this.changePassword(request, (User)ud);
            GraphicElementFactory gef = (GraphicElementFactory)session.getAttribute("SessionGraphicElementFactory");
            String favoriteFrame = gef.getLookFrame();
            return "/Main/" + favoriteFrame;
        }
        catch (AuthenticationException e) {
            SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.authentication.settings.passwordExpiration");
            String passwordChangeURL = settings.getString("passwordChangeURL", "/defaultPasswordAboutToExpire.jsp");
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return this.performUrlChangePasswordError(request, passwordChangeURL, ud);
        }
    }
}

