/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.admin.migration;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.domain.synchro.SynchroDomainReport;
import org.silverpeas.core.admin.service.AdminController;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;

public class DomainSP2LDAPBatch {
    private AdminController adminController = (AdminController)ServiceProvider.getService(AdminController.class, (Annotation[])new Annotation[0]);
    public static final String DOMAIN_SILVERPEAS_ID = "0";

    public OrganizationController getOrganisationController() {
        return OrganizationControllerProvider.getOrganisationController();
    }

    public AdminController getAdminController() {
        return this.adminController;
    }

    public ArrayList<HashMap<String, UserDetail>> processMigration(String domainLDAP_Id) throws Exception {
        SynchroDomainReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)"root.MSG_ENTER_METHOD");
        AdminController adminController = this.getAdminController();
        ArrayList<HashMap<String, UserDetail>> returnListLDAPUsers = new ArrayList<HashMap<String, UserDetail>>();
        HashMap<String, UserDetail> processedUsers = new HashMap<String, UserDetail>();
        HashMap<String, UserDetail> notProcessedSPUsers = new HashMap<String, UserDetail>();
        HashMap<String, UserDetail> listLDAPUsers = new HashMap<String, UserDetail>();
        try {
            String[] listLDAPUsersIds = adminController.getUserIdsOfDomain(domainLDAP_Id);
            SynchroDomainReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)("Utilisateurs du domaine Silverpeas=" + listLDAPUsersIds.length));
            if (listLDAPUsersIds.length == 0) {
                return returnListLDAPUsers;
            }
            for (String listLDAPUsersId : listLDAPUsersIds) {
                UserDetail userDetailLDAP = (UserDetail)this.getOrganisationController().getUserDetail(listLDAPUsersId);
                String keyName = (userDetailLDAP.getFirstName() + userDetailLDAP.getLastName()).toLowerCase();
                listLDAPUsers.put(keyName, userDetailLDAP);
            }
            String[] listSilverpeasUsersIds = adminController.getUserIdsOfDomain(DOMAIN_SILVERPEAS_ID);
            boolean processGroups = false;
            for (String listSilverpeasUsersId : listSilverpeasUsersIds) {
                UserDetail userDetail = (UserDetail)this.getOrganisationController().getUserDetail(listSilverpeasUsersId);
                String keyName = (userDetail.getFirstName() + userDetail.getLastName()).toLowerCase();
                if (listLDAPUsers.containsKey(keyName)) {
                    UserDetail userDetailLDAP = (UserDetail)listLDAPUsers.get(keyName);
                    adminController.synchronizeRemoveUser(userDetailLDAP.getId());
                    userDetail.setSpecificId(userDetailLDAP.getSpecificId());
                    userDetail.setDomainId(userDetailLDAP.getDomainId());
                    adminController.updateUser(userDetail);
                    processedUsers.put(keyName, userDetail);
                    processGroups = true;
                    continue;
                }
                notProcessedSPUsers.put(keyName, userDetail);
            }
            if (processGroups) {
                Group[] groups = this.getOrganisationController().getAllGroups();
                SynchroDomainReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)"DEBUT Migration des groupes du domaine SP vers le domaine mixte...");
                for (Group group : groups) {
                    boolean processGroup = false;
                    if (!DOMAIN_SILVERPEAS_ID.equals(group.getDomainId())) continue;
                    UserDetail[] usersOfGroup = this.getAdminController().getAllUsersOfGroup(group.getId());
                    for (int j = 0; j < usersOfGroup.length && !processGroup; ++j) {
                        UserDetail userDetail = usersOfGroup[j];
                        String userKeyName = (userDetail.getFirstName() + userDetail.getLastName()).toLowerCase();
                        if (!processedUsers.containsKey(userKeyName)) continue;
                        processGroup = true;
                    }
                    if (!processGroup) continue;
                    int nextId = DBUtil.getNextId((String)"ST_GROUP", (String)"specificId");
                    ((GroupDetail)group).setSpecificId(Integer.toString(nextId));
                    ((GroupDetail)group).setDomainId(null);
                    adminController.updateGroup((GroupDetail)group);
                    SynchroDomainReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)("- Groupe " + group.getName() + " avec " + group.getUserIds().length + " utilisateurs d&eacute;plac&eacute;s dans le domaine Mixte"));
                }
                SynchroDomainReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)"FIN Migration des groupes du domaine SP vers le domaine mixte...");
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            throw new AdminException("Fail to migrate the Silverpeas accounts", (Throwable)e);
        }
        SynchroDomainReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)("DEBUT Synchronisation post migration du domaine " + domainLDAP_Id));
        SynchroDomainReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)this.getAdminController().synchronizeSilverpeasWithDomain(domainLDAP_Id));
        SynchroDomainReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)("FIN Synchronisation post migration du domaine " + domainLDAP_Id));
        returnListLDAPUsers.add(processedUsers);
        returnListLDAPUsers.add(notProcessedSPUsers);
        returnListLDAPUsers.add(listLDAPUsers);
        SynchroDomainReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)"root.MSG_EXIT_METHOD");
        SynchroDomainReport.setReportLevel(null);
        return returnListLDAPUsers;
    }

    public Domain[] getDomains() throws AdminException {
        return this.getOrganisationController().getAllDomains();
    }

    public int getNbUsers(String domainId) {
        return this.getAdminController().getUserIdsOfDomain(domainId).length;
    }
}

