/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.springframework.social.linkedin.api.Group;
import org.springframework.social.linkedin.api.GroupSettings;
import org.springframework.social.linkedin.api.impl.json.LinkedInObjectMixin;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class GroupSettingsMixin
extends LinkedInObjectMixin {
    @JsonCreator
    GroupSettingsMixin(@JsonProperty(value="allowMessagesFromMembers") Boolean allowMessagesFromMembers, @JsonProperty(value="emailAnnouncementsFromManagers") Boolean emailAnnouncementsFromManagers, @JsonProperty(value="emailDigestFrequency") @JsonDeserialize(using=EmailDigestFrequencyDeserializer.class) GroupSettings.EmailDigestFrequency emailDigestFrequency, @JsonProperty(value="emailForEveryNewPost") Boolean emailForEveryNewPost, @JsonProperty(value="group") Group group, @JsonProperty(value="membershipState") @JsonDeserialize(using=MembershipStateDeserializer.class) Group.MembershipState membershipState, @JsonProperty(value="showGroupLogoInProfile") Boolean showGroupLogoInProfile) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MembershipStateDeserializer
    extends JsonDeserializer<Group.MembershipState> {
        private MembershipStateDeserializer() {
        }

        public Group.MembershipState deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node;
            if (jp.hasCurrentToken() && jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT) && (node = (JsonNode)jp.readValueAs(JsonNode.class)).has("code")) {
                return Group.MembershipState.valueOf(node.get("code").textValue().replace('-', '_').toUpperCase());
            }
            throw ctxt.mappingException("Expected JSON object");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmailDigestFrequencyDeserializer
    extends JsonDeserializer<GroupSettings.EmailDigestFrequency> {
        private EmailDigestFrequencyDeserializer() {
        }

        public GroupSettings.EmailDigestFrequency deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node;
            if (jp.hasCurrentToken() && jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT) && (node = (JsonNode)jp.readValueAs(JsonNode.class)).has("code")) {
                return GroupSettings.EmailDigestFrequency.valueOf(node.get("code").textValue().replace('-', '_').toUpperCase());
            }
            throw ctxt.mappingException("Expected JSON object");
        }
    }
}

