/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth2;

import java.io.IOException;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.oauth2.OAuth2Version;
import org.springframework.social.support.HttpRequestDecorator;

class OAuth2RequestInterceptor
implements ClientHttpRequestInterceptor {
    private final String accessToken;
    private final OAuth2Version oauth2Version;

    public OAuth2RequestInterceptor(String accessToken, OAuth2Version oauth2Version) {
        this.accessToken = accessToken;
        this.oauth2Version = oauth2Version;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        HttpRequestDecorator protectedResourceRequest = new HttpRequestDecorator(request);
        protectedResourceRequest.getHeaders().set("Authorization", this.oauth2Version.getAuthorizationHeaderValue(this.accessToken));
        return execution.execute((HttpRequest)protectedResourceRequest, body);
    }
}

