/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.jdbcconnector.service;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.silverpeas.components.jdbcconnector.service.JdbcConnectorRuntimeException;
import org.silverpeas.components.jdbcconnector.service.TableFieldValue;

public class TableRow {
    private final Map<String, Comparable> fields = new LinkedHashMap<String, Comparable>();

    TableRow(ResultSet rs) {
        try {
            ResultSetMetaData rsMetaData = rs.getMetaData();
            for (int i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                Object value = rs.getObject(i);
                Comparable valueToStore = value == null ? null : (value instanceof Comparable ? (Comparable)value : new TableFieldValue(value));
                this.fields.put(rsMetaData.getColumnName(i), valueToStore);
            }
        }
        catch (SQLException e) {
            throw new JdbcConnectorRuntimeException(e);
        }
    }

    public List<String> getFieldNames() {
        return new ArrayList<String>(this.fields.keySet());
    }

    public Map<String, Object> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public Comparable getFieldValue(String field) {
        return this.fields.get(field);
    }
}

