/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.util.DSMLHandler;
import com.novell.ldap.util.LDAPReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.helpers.DefaultHandler;

public class DSMLReader
implements LDAPReader {
    private int messageIndex = 0;
    private DSMLHandler handler = new DSMLHandler();
    private boolean requestFile = true;
    private String version = "2.0";

    public DSMLReader(String dsmlFile) throws LDAPLocalException, FileNotFoundException {
        this(new FileReader(dsmlFile));
    }

    public DSMLReader(InputStream inputStream) throws LDAPLocalException, UnsupportedEncodingException {
        this(new InputStreamReader(inputStream, "UTF8"));
    }

    public DSMLReader(Reader reader) throws LDAPLocalException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            InputSource is = new InputSource(reader);
            saxParser.parse(is, (DefaultHandler)this.handler);
        }
        catch (FactoryConfigurationError e) {
            throw new LDAPLocalException("The SAX parser factory is configured incorrectly:" + e, 82, e);
        }
        catch (ParserConfigurationException e) {
            throw new LDAPLocalException("The SAX parser is configured incorrectly:" + e, 82, e);
        }
        catch (SAXNotRecognizedException e) {
            throw new LDAPLocalException(null, 2, e);
        }
        catch (SAXException e) {
            throw new LDAPLocalException("The following error occured while parsing DSML: " + e, 84, e);
        }
        catch (IOException e) {
            throw new LDAPLocalException("The following error occured while reading DSML: " + e, 82, e);
        }
    }

    public LDAPMessage readMessage() {
        if (this.messageIndex >= this.handler.getQueue().size()) {
            return null;
        }
        return (LDAPMessage)this.handler.getQueue().get(this.messageIndex++);
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isRequest() {
        return this.requestFile;
    }

    public String getBatchRequestID() {
        return this.handler.getBatchRequestID();
    }

    public boolean isParallelProcessing() {
        return this.handler.isParallelProcessing();
    }

    public boolean isResponseUnordered() {
        return this.handler.isResponseUnordered();
    }

    public boolean isResumeOnError() {
        return this.handler.isResumeOnError();
    }

    public ArrayList getErrors() {
        return this.handler.getErrors();
    }
}

