/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.LDAPAddRequest;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPBindRequest;
import com.novell.ldap.LDAPCompareRequest;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedRequest;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPModifyRequest;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchRequest;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.LDAPSearchResultReference;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class DOMWriter
implements LDAPWriter {
    private Document doc;
    private Element root;
    private int state = 0;
    private static final int NEW_BATCH = 0;
    private static final int REQUEST_BATCH = 1;
    private static final int RESPONSE_BATCH = 2;
    private static final int SEARCH_RESPONSE = 3;
    private Element searchNode;

    public DOMWriter() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.doc = builder.newDocument();
    }

    public String getVersion() {
        return "2.0";
    }

    public boolean isRequest() {
        return this.root.getNodeName().equals("batchRequest");
    }

    public void writeComments(String comments) throws IOException {
    }

    public void writeMessage(LDAPMessage message) throws LDAPLocalException, IOException {
        this.checkState(message);
        if (message.getType() == 4 || message.getType() == 5 || message.getType() == 19) {
            this.searchNode.appendChild(this.message2Element(message));
        } else {
            this.root.appendChild(this.message2Element(message));
        }
        if (message.getType() == 5) {
            this.state = 2;
            this.searchNode = null;
        }
    }

    public void writeEntry(LDAPEntry entry) throws LDAPLocalException {
        this.checkState(entry);
        this.myWriteEntry(entry, null);
    }

    public void writeEntry(LDAPEntry entry, LDAPControl[] controls) throws LDAPLocalException {
        this.checkState(entry);
        this.myWriteEntry(entry, controls);
    }

    public void writeEntry(LDAPEntry entry, LDAPControl[] controls, String requestID) throws LDAPLocalException {
        this.checkState(entry);
        Element e = this.myWriteEntry(entry, controls);
        if (requestID != null && requestID.length() != 0) {
            e.setAttribute("requestID", requestID);
        }
    }

    private Element myWriteEntry(LDAPEntry entry, LDAPControl[] controls) {
        Element e = this.doc.createElement("searchResultEntry");
        e.setAttribute("dn", entry.getDN());
        LDAPAttributeSet set = entry.getAttributeSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            LDAPAttribute attr = (LDAPAttribute)iterator.next();
            Element attribute = this.doc.createElement("attr");
            this.writeAttribute(attribute, attr);
            e.appendChild(attribute);
        }
        if (controls != null) {
            this.writeControls(e, controls);
        }
        this.searchNode.appendChild(e);
        return e;
    }

    private void writeAttribute(Element attribute, LDAPAttribute attr) {
        attribute.setAttribute("name", attr.getName());
        String[] values = attr.getStringValueArray();
        byte[][] bytevalues = attr.getByteValueArray();
        for (int i = 0; i < values.length; ++i) {
            Element value = this.doc.createElement("value");
            if (Base64.isValidUTF8(bytevalues[i], false)) {
                value.appendChild(this.doc.createTextNode(values[i]));
            } else {
                value.setAttribute("xsi:type", "base64Binary");
                value.appendChild(this.doc.createTextNode(Base64.encode(bytevalues[i])));
            }
            attribute.appendChild(value);
        }
    }

    public Element message2Element(LDAPMessage message) {
        Element e = null;
        switch (message.getType()) {
            case 0: {
                e = this.doc.createElement("authRequest");
                e.setAttribute("principle", ((LDAPBindRequest)message).getAuthenticationDN());
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Writing of an unbind request is not currently supported");
            }
            case 3: {
                e = this.doc.createElement("searchRequest");
                LDAPSearchRequest sr = (LDAPSearchRequest)message;
                e.setAttribute("dn", sr.getDN());
                Element filter = this.doc.createElement("filter");
                this.writeFilter(filter, sr.getSearchFilter());
                e.appendChild(filter);
                Element attributes = this.doc.createElement("attributes");
                String[] attrNames = sr.getAttributes();
                for (int i = 0; i < attrNames.length; ++i) {
                    Element attribute = this.doc.createElement("attribute");
                    attribute.setAttribute("name", attrNames[i]);
                    attributes.appendChild(attribute);
                }
                e.appendChild(attributes);
                int temp = sr.getScope();
                if (temp == 0) {
                    e.setAttribute("scope", "baseObject");
                } else if (temp == 1) {
                    e.setAttribute("scope", "singleLevel");
                } else if (temp == 2) {
                    e.setAttribute("scope", "wholeSubtree");
                }
                temp = sr.getDereference();
                if (temp == 0) {
                    e.setAttribute("derefAliases", "neverDerefAliases");
                } else if (temp == 1) {
                    e.setAttribute("derefAliases", "derefInSearching");
                } else if (temp == 2) {
                    e.setAttribute("derefAliases", "derefFindingBaseObj");
                } else if (temp == 3) {
                    e.setAttribute("derefAliases", "derefAlways");
                }
                temp = sr.getMaxResults();
                if (temp != 0) {
                    e.setAttribute("sizeLimit", Integer.toString(temp));
                }
                if ((temp = sr.getServerTimeLimit()) != 0) {
                    e.setAttribute("timeLimit", Integer.toString(temp));
                }
                if (!sr.isTypesOnly()) break;
                e.setAttribute("typesOnly", "true");
                break;
            }
            case 6: {
                e = this.doc.createElement("modifyRequest");
                LDAPModifyRequest modreq = (LDAPModifyRequest)message;
                e.setAttribute("dn", modreq.getDN());
                LDAPModification[] mods = modreq.getModifications();
                for (int i = 0; i < mods.length; ++i) {
                    Element m = this.doc.createElement("modification");
                    LDAPAttribute attr = mods[i].getAttribute();
                    if (mods[i].getOp() == 0) {
                        m.setAttribute("operation", "add");
                    } else if (mods[i].getOp() == 1) {
                        m.setAttribute("operation", "delete");
                    } else if (mods[i].getOp() == 2) {
                        m.setAttribute("operation", "replace");
                    }
                    this.writeAttribute(m, attr);
                    e.appendChild(m);
                }
                break;
            }
            case 8: {
                e = this.doc.createElement("addRequest");
                LDAPAddRequest add = (LDAPAddRequest)message;
                LDAPEntry entry = add.getEntry();
                e.setAttribute("dn", entry.getDN());
                Iterator attrs = entry.getAttributeSet().iterator();
                while (attrs.hasNext()) {
                    Element a = this.doc.createElement("attr");
                    this.writeAttribute(a, (LDAPAttribute)attrs.next());
                    e.appendChild(a);
                }
                break;
            }
            case 10: {
                e = this.doc.createElement("delRequest");
                e.setAttribute("dn", ((LDAPDeleteRequest)message).getDN());
                break;
            }
            case 12: {
                e = this.doc.createElement("modDNRequest");
                LDAPModifyDNRequest moddn = (LDAPModifyDNRequest)message;
                e.setAttribute("dn", moddn.getDN());
                e.setAttribute("newrdn", moddn.getNewRDN());
                e.setAttribute("deleteoldrdn", moddn.getDeleteOldRDN() + "");
                String temp = moddn.getParentDN();
                if (temp == null || temp.length() <= 0) break;
                e.setAttribute("newSuperior", temp);
                break;
            }
            case 14: {
                e = this.doc.createElement("compareRequest");
                LDAPCompareRequest comp = (LDAPCompareRequest)message;
                e.setAttribute("dn", comp.getDN());
                Element assertion = this.doc.createElement("assertion");
                assertion.setAttribute("name", comp.getAttributeDescription());
                e.appendChild(assertion);
                Element value = this.doc.createElement("value");
                assertion.appendChild(value);
                byte[] compareValue = comp.getAssertionValue();
                if (Base64.isValidUTF8(compareValue, false)) {
                    try {
                        value.appendChild(this.doc.createTextNode(new String(compareValue, "UTF-8")));
                        break;
                    }
                    catch (UnsupportedEncodingException uee) {
                        throw new RuntimeException("UTF-8 not supported by JVM:" + uee);
                    }
                }
                value.setNodeValue(Base64.encode(compareValue));
                break;
            }
            case 16: {
                e = this.doc.createElement("abandonRequest");
                e.setAttribute("abandonID", DOMWriter.findRequestID(message));
                break;
            }
            case 23: {
                e = this.doc.createElement("extendedRequest");
                LDAPExtendedOperation xreq = ((LDAPExtendedRequest)message).getExtendedOperation();
                Element reqName = this.doc.createElement("requestName");
                reqName.appendChild(this.doc.createTextNode(xreq.getID()));
                e.appendChild(reqName);
                byte[] value = xreq.getValue();
                if (value == null) break;
                Element reqValue = this.doc.createElement("requestValue");
                reqValue.setAttribute("xsi:type", "xsd:base64Binary");
                reqValue.appendChild(this.doc.createTextNode(Base64.encode(xreq.getValue())));
                e.appendChild(reqValue);
                break;
            }
            case 4: {
                e = this.myWriteEntry(((LDAPSearchResult)message).getEntry(), message.getControls());
                break;
            }
            case 19: {
                e = this.doc.createElement("searchResultReference");
                String[] refs = ((LDAPSearchResultReference)message).getReferrals();
                for (int i = 0; i < refs.length; ++i) {
                    Element ref = this.doc.createElement("ref");
                    Text value = this.doc.createTextNode(refs[i]);
                    ref.appendChild(value);
                    e.appendChild(ref);
                }
                break;
            }
            case 5: {
                e = this.doc.createElement("searchResultDone");
                this.writeResult(e, (LDAPResponse)message);
                break;
            }
            case 7: {
                e = this.doc.createElement("modifyResponse");
                this.writeResult(e, (LDAPResponse)message);
                break;
            }
            case 9: {
                e = this.doc.createElement("addResponse");
                this.writeResult(e, (LDAPResponse)message);
                break;
            }
            case 11: {
                e = this.doc.createElement("delResponse");
                this.writeResult(e, (LDAPResponse)message);
                break;
            }
            case 13: {
                e = this.doc.createElement("modDNResponse");
                this.writeResult(e, (LDAPResponse)message);
                break;
            }
            case 15: {
                e = this.doc.createElement("compareResponse");
                this.writeResult(e, (LDAPResponse)message);
                break;
            }
            case 24: {
                LDAPExtendedResponse xResp = (LDAPExtendedResponse)message;
                e = this.doc.createElement("extendedResponse");
                this.writeResult(e, (LDAPResponse)message);
                Element resp = this.doc.createElement("responseName");
                Text text = this.doc.createTextNode(xResp.getID());
                resp.appendChild(text);
                e.appendChild(resp);
                byte[] value = xResp.getValue();
                if (value == null) break;
                resp = this.doc.createElement("response");
                resp.setAttribute("xsi:type", "base64Binary");
                resp.appendChild(this.doc.createTextNode(Base64.encode(value)));
                e.appendChild(resp);
            }
        }
        String id = DOMWriter.findRequestID(message);
        if (id != null && id.length() != 0) {
            e.setAttribute("requestID", id);
        }
        return e;
    }

    private void writeMatching(Element newElement, Iterator itr) {
        newElement.setAttribute("name", (String)itr.next());
        Element valueNode = this.doc.createElement("value");
        newElement.appendChild(valueNode);
        byte[] value = (byte[])itr.next();
        String text = this.byte2String(value);
        valueNode.appendChild(this.doc.createTextNode(text));
    }

    private void writeFilter(Element e, Iterator itr) {
        int op = -1;
        Element newElement = null;
        while (itr.hasNext()) {
            Object filterpart = itr.next();
            if (filterpart instanceof Integer) {
                op = (Integer)filterpart;
                switch (op) {
                    case 0: {
                        newElement = this.doc.createElement("and");
                        break;
                    }
                    case 1: {
                        newElement = this.doc.createElement("or");
                        break;
                    }
                    case 2: {
                        newElement = this.doc.createElement("not");
                        break;
                    }
                    case 3: {
                        newElement = this.doc.createElement("equalityMatch");
                        this.writeMatching(newElement, itr);
                        break;
                    }
                    case 5: {
                        newElement = this.doc.createElement("greaterOrEqual");
                        this.writeMatching(newElement, itr);
                        break;
                    }
                    case 6: {
                        newElement = this.doc.createElement("lessOrEqual");
                        this.writeMatching(newElement, itr);
                        break;
                    }
                    case 8: {
                        newElement = this.doc.createElement("approxMatch");
                        this.writeMatching(newElement, itr);
                        break;
                    }
                    case 7: {
                        newElement = this.doc.createElement("present");
                        newElement.setAttribute("name", (String)itr.next());
                        break;
                    }
                    case 9: {
                        newElement = this.doc.createElement("extensibleMatch");
                        newElement.setAttribute("matchingRule", (String)itr.next());
                        newElement.setAttribute("name", (String)itr.next());
                        Element value = this.doc.createElement("value");
                        value.appendChild(this.doc.createTextNode((String)itr.next()));
                        newElement.appendChild(value);
                        break;
                    }
                    case 4: {
                        newElement = this.doc.createElement("substrings");
                        newElement.setAttribute("name", (String)itr.next());
                        while (itr.hasNext()) {
                            op = (Integer)itr.next();
                            Element nextSubString = null;
                            switch (op) {
                                case 0: {
                                    nextSubString = this.doc.createElement("initial");
                                    break;
                                }
                                case 1: {
                                    nextSubString = this.doc.createElement("any");
                                    break;
                                }
                                case 2: {
                                    nextSubString = this.doc.createElement("final");
                                }
                            }
                            String value = (String)itr.next();
                            nextSubString.appendChild(this.doc.createTextNode(value));
                            newElement.appendChild(nextSubString);
                        }
                        break;
                    }
                }
                continue;
            }
            if (!(filterpart instanceof Iterator)) continue;
            this.writeFilter(newElement, (Iterator)filterpart);
        }
        e.appendChild(newElement);
    }

    private String byte2String(byte[] value) {
        String text = null;
        if (Base64.isValidUTF8(value, false)) {
            try {
                text = new String(value, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("UTF-8 not supported by JVM" + uee);
            }
        } else {
            text = Base64.encode(value);
        }
        return text;
    }

    private void writeResult(Element e, LDAPResponse response) {
        String[] urls;
        LDAPControl[] controls = response.getControls();
        if (controls != null) {
            this.writeControls(e, controls);
        }
        if ((urls = response.getReferrals()) != null) {
            for (int i = 0; i < urls.length; ++i) {
                Element referral = this.doc.createElement("referral");
                Text text = this.doc.createTextNode(urls[i]);
                referral.appendChild(text);
                e.appendChild(referral);
            }
        }
        Element resultCode = this.doc.createElement("resultCode");
        int result = response.getResultCode();
        resultCode.setAttribute("code", result + "");
        resultCode.setAttribute("descr", LDAPException.resultCodeToString(result));
        e.appendChild(resultCode);
        String temp = response.getErrorMessage();
        if (temp != null && temp.length() > 0) {
            Element err = this.doc.createElement("errorMessage");
            Text errorMessage = this.doc.createTextNode(temp);
            err.appendChild(errorMessage);
            e.appendChild(err);
        }
        if ((temp = response.getMatchedDN()) != null && temp.length() > 0) {
            e.setAttribute("matchedDN", temp);
        }
    }

    private void writeControls(Element e, LDAPControl[] controls) {
        for (int i = 0; i < controls.length; ++i) {
            Element el = this.doc.createElement("control");
            el.setAttribute("NumericOID", controls[i].getID());
            el.setAttribute("criticality", "" + controls[i].isCritical());
            byte[] byteValue = controls[i].getValue();
            if (byteValue != null) {
                Element value = this.doc.createElement("controlValue");
                value.setAttribute("xsi:type", "base64Binary");
                Text text = this.doc.createTextNode(Base64.encode(byteValue));
                value.appendChild(text);
                el.appendChild(value);
            }
            e.appendChild(el);
        }
    }

    public void writeError(Exception e) throws IOException {
        Element error = this.doc.createElement("errorResponse");
        if (e instanceof LDAPException) {
            switch (((LDAPException)e).getResultCode()) {
                case 84: {
                    error.setAttribute("type", "malformedRequest");
                    break;
                }
                case 82: {
                    error.setAttribute("type", "gatewayInternalError");
                    break;
                }
                case 49: {
                    error.setAttribute("type", "authenticationFailed");
                    break;
                }
                default: {
                    error.setAttribute("type", "other");
                    break;
                }
            }
        } else {
            error.setAttribute("type", "other");
        }
        Element message = this.doc.createElement("message");
        Text messageValue = this.doc.createTextNode(e.toString());
        message.appendChild(messageValue);
        error.appendChild(messageValue);
        this.root.appendChild(error);
    }

    private void checkState(LDAPMessage message) throws LDAPLocalException {
        boolean isResponse;
        boolean bl = isResponse = !message.isRequest();
        if (this.state == 0) {
            if (isResponse) {
                this.root = this.doc.createElement("batchResponse");
                this.root.setAttribute("xmlns", "urn:oasis:names:tc:DSML:2:0:core");
                this.root.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
                this.root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                this.state = 2;
            } else {
                this.root = this.doc.createElement("batchRequest");
                this.root.setAttribute("xmlns", "urn:oasis:names:tc:DSML:2:0:core");
                this.root.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
                this.root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                this.state = 1;
            }
        }
        if (this.state != 3 && (message.getType() == 4 || message.getType() == 5 || message.getType() == 19)) {
            this.searchNode = this.doc.createElement("searchResponse");
            this.searchNode.setAttribute("requestID", "" + DOMWriter.findRequestID(message));
            this.root.appendChild(this.searchNode);
            this.state = 3;
        } else {
            if (this.state == 1 && isResponse) {
                throw new LDAPLocalException("Attempted insertion of a response message in a request batch", 83);
            }
            if (!(this.state != 2 && this.state != 3 || isResponse)) {
                throw new LDAPLocalException("Attempted insertion of a request message in a response batch", 83);
            }
            if (this.state == 3 && message.getType() != 4 && message.getType() != 5 && message.getType() != 19) {
                throw new LDAPLocalException("Attempted insertion of a non-search result into a searchResponse", 83);
            }
        }
    }

    private void checkState(LDAPEntry entry) throws LDAPLocalException {
        boolean isResponse = true;
        if (this.state == 0) {
            this.root = this.doc.createElement("batchResponse");
            this.root.setAttribute("xmlns", "urn:oasis:names:tc:DSML:2:0:core");
            this.root.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            this.root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.state = 2;
        }
        if (this.state != 3) {
            this.searchNode = this.doc.createElement("searchResponse");
            this.root.appendChild(this.searchNode);
            this.state = 3;
        } else if (this.state == 1 && isResponse) {
            throw new LDAPLocalException("Attempted insertion of a response message in a request batch", 83);
        }
    }

    static String findRequestID(LDAPMessage message) {
        String tag = message.getTag();
        if (tag == null) {
            tag = message.getMessageID() + "";
        }
        return tag;
    }

    public Element getRootElement() {
        return this.root;
    }

    public void finish() throws IOException {
        this.doc.appendChild(this.root);
    }
}

