/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import com.novell.ldap.events.edir.eventdata.ReferralAddress;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SecurityEquivalenceEventData
implements EventResponseData {
    private String entryDN;
    private int retryCount;
    private String valueDN;
    private int referralCount;
    private List referralList = Collections.EMPTY_LIST;

    public SecurityEquivalenceEventData(ASN1Object message) throws IOException {
        byte[] data = ((ASN1OctetString)message).byteValue();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        LBERDecoder decode = new LBERDecoder();
        int[] length = new int[1];
        this.entryDN = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.retryCount = ((ASN1Integer)decode.decode(in, length)).intValue();
        this.valueDN = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        ASN1Sequence referalseq = (ASN1Sequence)decode.decode(in, length);
        this.referralCount = ((ASN1Integer)referalseq.get(0)).intValue();
        if (this.referralCount > 0) {
            this.referralList = new ArrayList();
            ASN1Sequence referalseqof = (ASN1Sequence)referalseq.get(1);
            for (int i = 0; i < this.referralCount; ++i) {
                this.referralList.add(new ReferralAddress((ASN1Sequence)referalseqof.get(i)));
            }
        }
    }

    public String getEntryDN() {
        return this.entryDN;
    }

    public int getReferralCount() {
        return this.referralCount;
    }

    public List getReferralList() {
        return this.referralList;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public String getValueDN() {
        return this.valueDN;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[SecurityEquivalenceEventData");
        buf.append("(EntryDN =" + this.getEntryDN() + ")");
        buf.append("(RetryCount =" + this.getRetryCount() + ")");
        buf.append("(valueDN =" + this.getValueDN() + ")");
        buf.append("(referralCount" + this.getReferralCount() + ")");
        buf.append("(Referral Lists =" + this.getReferralList() + ")");
        buf.append("]");
        return buf.toString();
    }
}

