/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchQueue;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.LDAPSearchResultReference;
import com.novell.ldap.client.Debug;
import com.novell.ldap.controls.LDAPEntryChangeControl;
import com.novell.ldap.controls.LDAPPersistSearchControl;
import com.novell.ldap.events.LDAPEvent;
import com.novell.ldap.events.LDAPEventListener;
import com.novell.ldap.events.LDAPEventSource;
import com.novell.ldap.events.LDAPExceptionEvent;
import com.novell.ldap.events.PSearchEventListener;
import com.novell.ldap.events.SearchReferralEvent;
import com.novell.ldap.events.SearchResultEvent;

public class PsearchEventSource
extends LDAPEventSource {
    public final void removeListener(PSearchEventListener alistener) throws LDAPException {
        if (alistener == null) {
            throw new IllegalArgumentException("No parameter can be Null.");
        }
        super.stopeventpolling(alistener);
    }

    public final void registerforEvent(LDAPConnection conn, String searchBase, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchConstraints constraints, int eventchangetype, boolean changeonly, PSearchEventListener alistener) throws LDAPException {
        if (conn == null || searchBase == null || filter == null || attrs == null || alistener == null) {
            throw new IllegalArgumentException("Null argument specified");
        }
        LDAPSearchConstraints searchconstraints = null;
        searchconstraints = constraints == null ? new LDAPSearchConstraints() : constraints;
        LDAPPersistSearchControl psCtrl = new LDAPPersistSearchControl(eventchangetype, changeonly, true, true);
        searchconstraints.setControls(psCtrl);
        LDAPSearchQueue queue = conn.search(searchBase, scope, filter, attrs, typesOnly, null, searchconstraints);
        PSearchEventsGenerator eventgenerator = null;
        int[] ids = queue.getMessageIDs();
        if (ids.length != 1) {
            throw new LDAPException(null, 82, "Unable to Obtain Message Id");
        }
        eventgenerator = new PSearchEventsGenerator(alistener, this);
        super.pollforevents(queue, conn, eventgenerator, ids[0], this);
    }

    private class PSearchEventsGenerator
    implements LDAPEventListener {
        private PSearchEventListener listener;
        private PsearchEventSource eventsource;

        PSearchEventsGenerator(PSearchEventListener alistener, PsearchEventSource aeventsource) {
            this.listener = alistener;
            this.eventsource = aeventsource;
        }

        public final void ldapEventNotification(LDAPEvent evt) {
            LDAPMessage response = evt.getContainedEventInformation();
            if (response != null) {
                switch (response.getType()) {
                    case 19: {
                        SearchReferralEvent event = new SearchReferralEvent(this.eventsource, (LDAPSearchResultReference)response);
                        this.listener.searchReferalEvent(event);
                        break;
                    }
                    case 4: {
                        int changeType = -1;
                        LDAPControl[] controls = response.getControls();
                        for (int i = 0; i < controls.length; ++i) {
                            if (!(controls[i] instanceof LDAPEntryChangeControl)) continue;
                            LDAPEntryChangeControl ecCtrl = (LDAPEntryChangeControl)controls[i];
                            changeType = ecCtrl.getChangeType();
                        }
                        SearchResultEvent resultevent = new SearchResultEvent(this.eventsource, (LDAPSearchResult)response, changeType);
                        this.listener.searchResultEvent(resultevent);
                        break;
                    }
                    case 5: {
                        LDAPResponse responsemsg = (LDAPResponse)response;
                        int resultCode = responsemsg.getResultCode();
                        Debug.trace("EventsTrace", "\nUnexpected success response.");
                        LDAPEvent ldapevent = new LDAPEvent(this.eventsource, responsemsg, 0, 15);
                        this.listener.ldapEventNotification(ldapevent);
                        break;
                    }
                    default: {
                        evt.setEventclassification(0);
                        this.listener.ldapEventNotification(evt);
                    }
                }
            }
        }

        public final void ldapExceptionNotification(LDAPExceptionEvent ldapevt) {
            this.listener.ldapExceptionNotification(ldapevt);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

