/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.client;

import com.novell.ldap.client.ArrayEnumeration;
import com.novell.ldap.client.AttributeQualifier;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;

public class SchemaParser {
    String rawString;
    String[] names = null;
    String id;
    String description;
    String syntax;
    String superior;
    String nameForm;
    String objectClass;
    String[] superiors;
    String[] required;
    String[] optional;
    String[] auxiliary;
    String[] precluded;
    String[] applies;
    boolean single = false;
    boolean obsolete = false;
    String equality;
    String ordering;
    String substring;
    boolean collective = false;
    boolean userMod = true;
    int usage = 0;
    int type = -1;
    int result;
    ArrayList qualifiers = new ArrayList();

    public SchemaParser(String aString) throws IOException {
        int index = aString.indexOf(92);
        if (index != -1) {
            StringBuffer newString = new StringBuffer(aString.substring(0, index));
            for (int i = index; i < aString.length(); ++i) {
                newString.append(aString.charAt(i));
                if (aString.charAt(i) != '\\') continue;
                newString.append('\\');
            }
            this.rawString = newString.toString();
        } else {
            this.rawString = aString;
        }
        StreamTokenizer st2 = new StreamTokenizer(new StringReader(this.rawString));
        st2.ordinaryChar(46);
        st2.ordinaryChars(48, 57);
        st2.ordinaryChar(123);
        st2.ordinaryChar(125);
        st2.ordinaryChar(95);
        st2.ordinaryChar(59);
        st2.wordChars(46, 57);
        st2.wordChars(123, 125);
        st2.wordChars(95, 95);
        st2.wordChars(59, 59);
        if (-1 != st2.nextToken() && st2.ttype == 40) {
            if (-3 == st2.nextToken()) {
                this.id = st2.sval;
            }
            while (-1 != st2.nextToken()) {
                String currName;
                ArrayList<String> values;
                if (st2.ttype != -3) continue;
                if (st2.sval.equalsIgnoreCase("NAME")) {
                    if (st2.nextToken() == 39) {
                        this.names = new String[1];
                        this.names[0] = st2.sval;
                        continue;
                    }
                    if (st2.ttype != 40) continue;
                    ArrayList<String> nameList = new ArrayList<String>();
                    while (st2.nextToken() == 39) {
                        if (st2.sval == null) continue;
                        nameList.add(st2.sval);
                    }
                    if (nameList.size() <= 0) continue;
                    this.names = new String[nameList.size()];
                    nameList.toArray(this.names);
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("DESC")) {
                    if (st2.nextToken() != 39) continue;
                    this.description = st2.sval;
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("SYNTAX")) {
                    this.result = st2.nextToken();
                    if (this.result != -3 && this.result != 39) continue;
                    this.syntax = st2.sval;
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("EQUALITY")) {
                    if (st2.nextToken() != -3) continue;
                    this.equality = st2.sval;
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("ORDERING")) {
                    if (st2.nextToken() != -3) continue;
                    this.ordering = st2.sval;
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("SUBSTR")) {
                    if (st2.nextToken() != -3) continue;
                    this.substring = st2.sval;
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("FORM")) {
                    if (st2.nextToken() != -3) continue;
                    this.nameForm = st2.sval;
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("OC")) {
                    if (st2.nextToken() != -3) continue;
                    this.objectClass = st2.sval;
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("SUP")) {
                    values = new ArrayList<String>();
                    st2.nextToken();
                    if (st2.ttype == 40) {
                        st2.nextToken();
                        while (st2.ttype != 41) {
                            if (st2.ttype != 36) {
                                values.add(st2.sval);
                            }
                            st2.nextToken();
                        }
                    } else {
                        values.add(st2.sval);
                        this.superior = st2.sval;
                    }
                    if (values.size() <= 0) continue;
                    this.superiors = new String[values.size()];
                    values.toArray(this.superiors);
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("SINGLE-VALUE")) {
                    this.single = true;
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("OBSOLETE")) {
                    this.obsolete = true;
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("COLLECTIVE")) {
                    this.collective = true;
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("NO-USER-MODIFICATION")) {
                    this.userMod = false;
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("MUST")) {
                    values = new ArrayList();
                    st2.nextToken();
                    if (st2.ttype == 40) {
                        st2.nextToken();
                        while (st2.ttype != 41) {
                            if (st2.ttype != 36) {
                                values.add(st2.sval);
                            }
                            st2.nextToken();
                        }
                    } else {
                        values.add(st2.sval);
                    }
                    if (values.size() <= 0) continue;
                    this.required = new String[values.size()];
                    values.toArray(this.required);
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("MAY")) {
                    values = new ArrayList();
                    st2.nextToken();
                    if (st2.ttype == 40) {
                        st2.nextToken();
                        while (st2.ttype != 41) {
                            if (st2.ttype != 36) {
                                values.add(st2.sval);
                            }
                            st2.nextToken();
                        }
                    } else {
                        values.add(st2.sval);
                    }
                    if (values.size() <= 0) continue;
                    this.optional = new String[values.size()];
                    values.toArray(this.optional);
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("NOT")) {
                    values = new ArrayList();
                    st2.nextToken();
                    if (st2.ttype == 40) {
                        st2.nextToken();
                        while (st2.ttype != 41) {
                            if (st2.ttype != 36) {
                                values.add(st2.sval);
                            }
                            st2.nextToken();
                        }
                    } else {
                        values.add(st2.sval);
                    }
                    if (values.size() <= 0) continue;
                    this.precluded = new String[values.size()];
                    values.toArray(this.precluded);
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("AUX")) {
                    values = new ArrayList();
                    st2.nextToken();
                    if (st2.ttype == 40) {
                        st2.nextToken();
                        while (st2.ttype != 41) {
                            if (st2.ttype != 36) {
                                values.add(st2.sval);
                            }
                            st2.nextToken();
                        }
                    } else {
                        values.add(st2.sval);
                    }
                    if (values.size() <= 0) continue;
                    this.auxiliary = new String[values.size()];
                    values.toArray(this.auxiliary);
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("ABSTRACT")) {
                    this.type = 0;
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("STRUCTURAL")) {
                    this.type = 1;
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("AUXILIARY")) {
                    this.type = 2;
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("USAGE")) {
                    if (st2.nextToken() != -3) continue;
                    currName = st2.sval;
                    if (currName.equalsIgnoreCase("directoryOperation")) {
                        this.usage = 1;
                        continue;
                    }
                    if (currName.equalsIgnoreCase("distributedOperation")) {
                        this.usage = 2;
                        continue;
                    }
                    if (currName.equalsIgnoreCase("dSAOperation")) {
                        this.usage = 3;
                        continue;
                    }
                    if (!currName.equalsIgnoreCase("userApplications")) continue;
                    this.usage = 0;
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("APPLIES")) {
                    values = new ArrayList();
                    st2.nextToken();
                    if (st2.ttype == 40) {
                        st2.nextToken();
                        while (st2.ttype != 41) {
                            if (st2.ttype != 36) {
                                values.add(st2.sval);
                            }
                            st2.nextToken();
                        }
                    } else {
                        values.add(st2.sval);
                    }
                    if (values.size() <= 0) continue;
                    this.applies = new String[values.size()];
                    values.toArray(this.applies);
                    continue;
                }
                currName = st2.sval;
                AttributeQualifier q = this.parseQualifier(st2, currName);
                if (q == null) continue;
                this.qualifiers.add(q);
            }
        }
    }

    public final void setRawString(String rawString) {
        this.rawString = rawString;
    }

    public final String getRawString() {
        return this.rawString;
    }

    public final String[] getNames() {
        return this.names;
    }

    public final Enumeration getQualifiers() {
        return new ArrayEnumeration(this.qualifiers.toArray());
    }

    public final String getID() {
        return this.id;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getSyntax() {
        return this.syntax;
    }

    public final String getSuperior() {
        return this.superior;
    }

    public final boolean getSingle() {
        return this.single;
    }

    public final boolean getObsolete() {
        return this.obsolete;
    }

    public final String getEquality() {
        return this.equality;
    }

    public final String getOrdering() {
        return this.ordering;
    }

    public final String getSubstring() {
        return this.substring;
    }

    public final boolean getCollective() {
        return this.collective;
    }

    public final boolean getUserMod() {
        return this.userMod;
    }

    public final int getUsage() {
        return this.usage;
    }

    public final int getType() {
        return this.type;
    }

    public final String[] getSuperiors() {
        return this.superiors;
    }

    public final String[] getRequired() {
        return this.required;
    }

    public final String[] getOptional() {
        return this.optional;
    }

    public final String[] getAuxiliary() {
        return this.auxiliary;
    }

    public final String[] getPrecluded() {
        return this.precluded;
    }

    public final String[] getApplies() {
        return this.applies;
    }

    public final String getNameForm() {
        return this.nameForm;
    }

    public final String getObjectClass() {
        return this.nameForm;
    }

    private AttributeQualifier parseQualifier(StreamTokenizer st, String name) throws IOException {
        ArrayList<String> values = new ArrayList<String>(5);
        if (st.nextToken() == 39) {
            values.add(st.sval);
        } else if (st.ttype == 40) {
            while (st.nextToken() == 39) {
                values.add(st.sval);
            }
        }
        String[] valArray = new String[values.size()];
        valArray = values.toArray(valArray);
        return new AttributeQualifier(name, valArray);
    }
}

