/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.asn1;

import com.novell.ldap.asn1.ASN1Encoder;
import com.novell.ldap.asn1.ASN1Identifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public abstract class ASN1Object
implements Serializable {
    private ASN1Identifier id;

    public ASN1Object(ASN1Identifier id) {
        this.id = id;
    }

    public abstract void encode(ASN1Encoder var1, OutputStream var2) throws IOException;

    public ASN1Identifier getIdentifier() {
        return this.id;
    }

    protected void setIdentifier(ASN1Identifier id) {
        this.id = id;
    }

    public final byte[] getEncoding(ASN1Encoder enc) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.encode(enc, out);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while encoding to byte array: " + e.toString());
        }
        return out.toByteArray();
    }

    public String toString() {
        String[] classTypes = new String[]{"[UNIVERSAL ", "[APPLICATION ", "[CONTEXT ", "[PRIVATE "};
        StringBuffer sb = new StringBuffer();
        ASN1Identifier id = this.getIdentifier();
        sb.append(classTypes[id.getASN1Class()]).append(id.getTag()).append("] ");
        return sb.toString();
    }
}

