/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPReferralHandler;
import com.novell.ldap.client.Debug;
import java.util.Hashtable;

public class LDAPSearchConstraints
extends LDAPConstraints {
    private int dereference = 0;
    private int serverTimeLimit = 0;
    private int maxResults = 1000;
    private int batchSize = 1;
    private static Object nameLock = new Object();
    private static int lSConsNum = 0;
    private String name;
    public static final int DEREF_NEVER = 0;
    public static final int DEREF_SEARCHING = 1;
    public static final int DEREF_FINDING = 2;
    public static final int DEREF_ALWAYS = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPSearchConstraints() {
        Object object = nameLock;
        synchronized (object) {
            this.name = "LDAPSearchConstraints(" + ++lSConsNum + "): ";
        }
        Debug.trace("APIRequests", this.name + "Created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPSearchConstraints(LDAPConstraints cons) {
        super(cons.getTimeLimit(), cons.getReferralFollowing(), cons.getReferralHandler(), cons.getHopLimit());
        Hashtable lp;
        LDAPControl[] lsc = cons.getControls();
        if (lsc != null) {
            super.setControls((LDAPControl[])lsc.clone());
        }
        if ((lp = cons.getProperties()) != null) {
            super.setProperties((Hashtable)lp.clone());
        }
        if (cons instanceof LDAPSearchConstraints) {
            LDAPSearchConstraints scons = (LDAPSearchConstraints)cons;
            this.serverTimeLimit = scons.getServerTimeLimit();
            this.dereference = scons.getDereference();
            this.maxResults = scons.getMaxResults();
            this.batchSize = scons.getBatchSize();
        }
        Object object = nameLock;
        synchronized (object) {
            this.name = "LDAPSearchConstraints(" + ++lSConsNum + "): ";
        }
        Debug.trace("APIRequests", this.name + "Created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPSearchConstraints(int msLimit, int serverTimeLimit, int dereference, int maxResults, boolean doReferrals, int batchSize, LDAPReferralHandler handler, int hop_limit) {
        super(msLimit, doReferrals, handler, hop_limit);
        this.serverTimeLimit = serverTimeLimit;
        this.dereference = dereference;
        this.maxResults = maxResults;
        this.batchSize = batchSize;
        Object object = nameLock;
        synchronized (object) {
            this.name = "LDAPSearchConstraints(" + ++lSConsNum + "): ";
        }
        Debug.trace("APIRequests", this.name + "Created");
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getDereference() {
        return this.dereference;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public int getServerTimeLimit() {
        return this.serverTimeLimit;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setDereference(int dereference) {
        this.dereference = dereference;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void setServerTimeLimit(int seconds) {
        this.serverTimeLimit = seconds;
    }
}

