/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public class LDAPCompareAttrNames
implements Comparator {
    private String[] sortByNames;
    private boolean[] sortAscending;
    private Locale location = Locale.getDefault();
    private Collator collator = Collator.getInstance();

    public LDAPCompareAttrNames(String attrName) {
        this.sortByNames = new String[1];
        this.sortByNames[0] = attrName;
        this.sortAscending = new boolean[1];
        this.sortAscending[0] = true;
    }

    public LDAPCompareAttrNames(String attrName, boolean ascendingFlag) {
        this.sortByNames = new String[1];
        this.sortByNames[0] = attrName;
        this.sortAscending = new boolean[1];
        this.sortAscending[0] = ascendingFlag;
    }

    public LDAPCompareAttrNames(String[] attrNames) {
        this.sortByNames = new String[attrNames.length];
        this.sortAscending = new boolean[attrNames.length];
        for (int i = 0; i < attrNames.length; ++i) {
            this.sortByNames[i] = attrNames[i];
            this.sortAscending[i] = true;
        }
    }

    public LDAPCompareAttrNames(String[] attrNames, boolean[] ascendingFlags) throws LDAPException {
        if (attrNames.length != ascendingFlags.length) {
            throw new LDAPException("UNEQUAL_LENGTHS", 18, null);
        }
        this.sortByNames = new String[attrNames.length];
        this.sortAscending = new boolean[ascendingFlags.length];
        for (int i = 0; i < attrNames.length; ++i) {
            this.sortByNames[i] = attrNames[i];
            this.sortAscending[i] = ascendingFlags[i];
        }
    }

    public Locale getLocale() {
        return this.location;
    }

    public void setLocale(Locale locale) {
        this.collator = Collator.getInstance(locale);
        this.location = locale;
    }

    public int compare(Object object1, Object object2) {
        int compare;
        LDAPEntry entry1 = (LDAPEntry)object1;
        LDAPEntry entry2 = (LDAPEntry)object2;
        int i = 0;
        if (this.collator == null) {
            this.collator = Collator.getInstance();
        }
        do {
            LDAPAttribute one = entry1.getAttribute(this.sortByNames[i]);
            LDAPAttribute two = entry2.getAttribute(this.sortByNames[i]);
            if (one != null && two != null) {
                String[] first = one.getStringValueArray();
                String[] second = two.getStringValueArray();
                compare = this.collator.compare(first[0], second[0]);
                continue;
            }
            compare = one != null ? -1 : (two != null ? 1 : 0);
        } while (compare == 0 && ++i < this.sortByNames.length);
        if (this.sortAscending[i - 1]) {
            return compare;
        }
        return -compare;
    }

    public boolean equals(Object comparator) {
        if (!(comparator instanceof LDAPCompareAttrNames)) {
            return false;
        }
        LDAPCompareAttrNames comp = (LDAPCompareAttrNames)comparator;
        if (comp.sortByNames.length != this.sortByNames.length || comp.sortAscending.length != this.sortAscending.length) {
            return false;
        }
        for (int i = 0; i < this.sortByNames.length; ++i) {
            if (comp.sortAscending[i] != this.sortAscending[i]) {
                return false;
            }
            if (comp.sortByNames[i].equalsIgnoreCase(this.sortByNames[i])) continue;
            return false;
        }
        return true;
    }
}

