/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPException;
import com.novell.ldap.Message;
import com.novell.ldap.client.Debug;

class InterThreadException
extends LDAPException {
    private Message request;

    InterThreadException(String message, Object[] arguments, int resultCode, Throwable rootException, Message request) {
        super(message, arguments, resultCode, (String)null, rootException);
        this.request = request;
        Debug.trace("Messages", "InterThreadException created with msg \"" + this.getMessage() + "\" and  code " + resultCode);
        if (rootException != null) {
            Debug.trace("Messages", "InterThreadException has rootException - " + rootException.toString());
        }
    }

    final int getMessageID() {
        if (this.request == null) {
            return -1;
        }
        return this.request.getMessageID();
    }

    final int getReplyType() {
        if (this.request == null) {
            return -1;
        }
        int reqType = this.request.getMessageType();
        int responseType = -1;
        switch (reqType) {
            case 0: {
                responseType = 1;
                break;
            }
            case 2: {
                responseType = -1;
                break;
            }
            case 3: {
                responseType = 5;
                break;
            }
            case 6: {
                responseType = 7;
                break;
            }
            case 8: {
                responseType = 9;
                break;
            }
            case 10: {
                responseType = 11;
                break;
            }
            case 12: {
                responseType = 13;
                break;
            }
            case 14: {
                responseType = 15;
                break;
            }
            case 16: {
                responseType = -1;
                break;
            }
            case 23: {
                responseType = 24;
            }
        }
        return responseType;
    }
}

