/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.InterThreadException;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedRequest;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.LDAPTLSSocketFactory;
import com.novell.ldap.LDAPUnbindRequest;
import com.novell.ldap.LDAPUnsolicitedNotificationListener;
import com.novell.ldap.Message;
import com.novell.ldap.MessageAgent;
import com.novell.ldap.MessageVector;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Length;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.asn1.LBEREncoder;
import com.novell.ldap.client.BindProperties;
import com.novell.ldap.client.Debug;
import com.novell.ldap.client.ReferralInfo;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;

final class Connection {
    private Object writeSemaphore = new Object();
    private int writeSemaphoreOwner = 0;
    private int writeSemaphoreCount = 0;
    private int ephemeralId = -1;
    private BindProperties bindProperties = null;
    private int bindSemaphoreId = 0;
    private Thread reader = null;
    private Thread deadReader = null;
    private IOException deadReaderException = null;
    private LBEREncoder encoder = new LBEREncoder();
    private LBERDecoder decoder = new LBERDecoder();
    private Socket socket = null;
    private Socket nonTLSBackup = null;
    private InputStream in = null;
    private OutputStream out = null;
    private boolean clientActive = true;
    private boolean unsolSvrShutDnNotification = false;
    private static final int CONTINUE_READING = -99;
    private static final int STOP_READING = -98;
    private int stopReaderMessageID = -99;
    private MessageVector messages = new MessageVector(5, 5);
    private ReferralInfo activeReferral = null;
    private Vector unsolicitedListeners = new Vector(3, 3);
    private static LDAPSocketFactory socketFactory = null;
    private LDAPSocketFactory mySocketFactory = null;
    private int myTimeOut = 0;
    private String host = null;
    private int port = 0;
    private int cloneCount = 0;
    private String name = "";
    private static Object nameLock = new Object();
    private static int connNum = 0;
    static String sdk = new String("4.6");
    static Integer protocol = new Integer(3);
    static String security = "simple";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection(LDAPSocketFactory factory) {
        if (factory != null) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkSetFactory();
            }
            this.mySocketFactory = factory;
        } else {
            this.mySocketFactory = socketFactory;
        }
        Object object = nameLock;
        synchronized (object) {
            this.name = "Connection(" + ++connNum + "): ";
        }
        Debug.trace("Messages", this.name + "Created");
    }

    Object copy() {
        Connection c = new Connection(this.mySocketFactory);
        c.host = this.host;
        c.port = this.port;
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection(int timeout) {
        this.myTimeOut = timeout;
        this.mySocketFactory = socketFactory;
        Object object = nameLock;
        synchronized (object) {
            this.name = "Connection(" + ++connNum + "): ";
        }
        Debug.trace("Messages", this.name + "Created");
    }

    Object copy_timeout() {
        Connection c = new Connection(this.myTimeOut);
        c.host = this.host;
        c.port = this.port;
        return c;
    }

    final int acquireWriteSemaphore() {
        return this.acquireWriteSemaphore(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int acquireWriteSemaphore(int msgId) {
        int id = msgId;
        Object object = this.writeSemaphore;
        synchronized (object) {
            if (id == 0) {
                id = this.ephemeralId = this.ephemeralId == Integer.MIN_VALUE ? (this.ephemeralId = -1) : (this.ephemeralId = this.ephemeralId - 1);
            }
            while (true) {
                if (this.writeSemaphoreOwner == 0) {
                    this.writeSemaphoreOwner = id;
                    break;
                }
                if (this.writeSemaphoreOwner == id) break;
                try {
                    this.writeSemaphore.wait();
                }
                catch (InterruptedException ex) {}
            }
            ++this.writeSemaphoreCount;
        }
        Debug.trace("BindSemaphore", this.name + "Acquired Socket Write Semaphore(" + id + ") count " + this.writeSemaphoreCount);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void freeWriteSemaphore(int msgId) {
        Debug.trace("BindSemaphore", this.name + "Free'd Socket Write Semaphore(" + msgId + ") count " + (this.writeSemaphoreCount - 1));
        Object object = this.writeSemaphore;
        synchronized (object) {
            if (this.writeSemaphoreOwner == 0) {
                throw new RuntimeException("Connection.freeWriteSemaphore(" + msgId + "): semaphore not owned by any thread");
            }
            if (this.writeSemaphoreOwner != msgId) {
                throw new RuntimeException("Connection.freeWriteSemaphore(" + msgId + "): thread does not own the semaphore, owned by " + this.writeSemaphoreOwner);
            }
            if (--this.writeSemaphoreCount == 0) {
                this.writeSemaphoreOwner = 0;
                this.writeSemaphore.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForReader(Thread thread) throws LDAPException {
        while (this.reader != thread) {
            try {
                Object lex;
                if (thread == null) {
                    Debug.trace("Messages", this.name + "waiting for reader thread to exit");
                } else {
                    Debug.trace("Messages", this.name + "waiting for reader thread to start");
                }
                if (thread == this.deadReader) {
                    if (thread == null) {
                        return;
                    }
                    Debug.trace("Messages", this.name + "reader already terminated, throw exception");
                    lex = this.deadReaderException;
                    this.deadReaderException = null;
                    this.deadReader = null;
                    throw new LDAPException("CONNECTION_READER", 91, null, (Throwable)lex);
                }
                lex = this;
                synchronized (lex) {
                    this.wait(5L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this.deadReaderException = null;
        this.deadReader = null;
    }

    void connect(String host, int port) throws LDAPException {
        this.connect(host, port, 0);
    }

    private void connect(String host, int port, int semaphoreId) throws LDAPException {
        Debug.trace("Messages", this.name + "connect(" + host + "," + port + ")");
        this.waitForReader(null);
        this.unsolSvrShutDnNotification = false;
        int semId = this.acquireWriteSemaphore(semaphoreId);
        if (port == 0) {
            port = 389;
        }
        try {
            if (this.in == null || this.out == null) {
                if (this.mySocketFactory != null) {
                    Debug.trace("Messages", this.name + "connect(socketFactory specified)");
                    this.socket = this.mySocketFactory.createSocket(host, port);
                } else {
                    this.socket = new Socket(host, port);
                    if (this.myTimeOut > 0) {
                        this.socket.setSoTimeout(this.myTimeOut);
                    }
                }
                this.in = this.socket.getInputStream();
                this.out = this.socket.getOutputStream();
            } else {
                Debug.trace("Messages", this.name + "connect(input/out Stream specified)");
            }
        }
        catch (IOException ioe) {
            this.freeWriteSemaphore(semId);
            throw new LDAPException("CONNECTION_ERROR", new Object[]{host, new Integer(port)}, 91, null, ioe);
        }
        this.host = host;
        this.port = port;
        this.startReader();
        this.freeWriteSemaphore(semId);
        Debug.trace("Messages", this.name + " connect: setup complete");
        this.clientActive = true;
    }

    final boolean isCloned() {
        return this.cloneCount > 0;
    }

    final synchronized void incrCloneCount() {
        ++this.cloneCount;
        Debug.trace("Messages", this.name + "incrCloneCount(" + this.cloneCount + ")");
    }

    final synchronized Connection destroyClone(boolean apiCall) {
        Debug.trace("Messages", this.name + "destroyClone(" + apiCall + ")");
        Connection conn = this;
        if (this.cloneCount > 0) {
            --this.cloneCount;
            Debug.trace("Messages", this.name + "destroyClone(" + this.cloneCount + ") create new connection");
            conn = apiCall ? (Connection)this.copy() : null;
        } else if (this.in != null) {
            Debug.trace("Messages", this.name + "destroyClone(" + this.cloneCount + ") destroy old connection");
            InterThreadException notify = new InterThreadException(apiCall ? "CONNECTION_CLOSED" : "CONNECTION_FINALIZED", null, 91, null, null);
            this.shutdown("destroy clone", 0, notify);
        }
        return conn;
    }

    static final void setSocketFactory(LDAPSocketFactory factory) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        socketFactory = factory;
    }

    final LDAPSocketFactory getSocketFactory() {
        return this.mySocketFactory;
    }

    final String getHost() {
        return this.host;
    }

    final int getPort() {
        return this.port;
    }

    int getBindSemId() {
        return this.bindSemaphoreId;
    }

    void setBindSemId(int id) {
        this.bindSemaphoreId = id;
    }

    void clearBindSemId() {
        this.bindSemaphoreId = 0;
    }

    final int getSocketTimeOut() {
        return this.myTimeOut;
    }

    final void setSocketTimeOut(int timeout) {
        try {
            if (this.socket != null) {
                this.socket.setSoTimeout(timeout);
            }
            this.myTimeOut = timeout;
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    boolean isBindSemIdClear() {
        return this.bindSemaphoreId == 0;
    }

    void writeMessage(Message info) throws LDAPException {
        this.messages.addElement(info);
        if (info.isBindRequest() && !this.isConnected() && this.host != null) {
            this.connect(this.host, this.port, info.getMessageID());
        }
        if (this.isConnected()) {
            LDAPMessage msg = info.getRequest();
            this.writeMessage(msg);
            return;
        }
        throw new LDAPException("CONNECTION_CLOSED", new Object[]{this.host, new Integer(this.port)}, 91, null, new IOException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeMessage(LDAPMessage msg) throws LDAPException {
        int id = this.bindSemaphoreId == 0 ? msg.getMessageID() : this.bindSemaphoreId;
        OutputStream myOut = this.out;
        Debug.trace("Messages", this.name + "Writing Message(" + msg.getMessageID() + ")");
        Debug.trace("RawInput", this.name + "RawWrite: " + msg.getASN1Object().toString());
        this.acquireWriteSemaphore(id);
        try {
            if (myOut == null) {
                throw new IOException("Output stream not initialized");
            }
            byte[] ber = msg.getASN1Object().getEncoding(this.encoder);
            myOut.write(ber, 0, ber.length);
            myOut.flush();
        }
        catch (IOException ioe) {
            Debug.trace("Messages", this.name + "I/O Exception on host" + this.host + ":" + this.port + " " + ioe.toString());
            if (this.clientActive) {
                if (this.unsolSvrShutDnNotification) {
                    throw new LDAPException("SERVER_SHUTDOWN_REQ", new Object[]{this.host, new Integer(this.port)}, 91, null, ioe);
                }
                throw new LDAPException("IO_EXCEPTION", new Object[]{this.host, new Integer(this.port)}, 91, null, ioe);
            }
        }
        finally {
            this.freeWriteSemaphore(id);
        }
    }

    final MessageAgent getMessageAgent(int msgId) throws NoSuchFieldException {
        Message info = this.messages.findMessageById(msgId);
        return info.getMessageAgent();
    }

    final boolean isBound() {
        if (this.bindProperties != null) {
            return !this.bindProperties.isAnonymous();
        }
        return false;
    }

    final boolean isConnected() {
        return this.in != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isConnectionAlive() {
        boolean isConn = false;
        LDAPExtendedOperation op = null;
        if (this.in != null) {
            isConn = true;
            op = new LDAPExtendedOperation("0.0.0.0", null);
            LDAPExtendedRequest msg = new LDAPExtendedRequest(op, null);
            int id = msg.getMessageID();
            this.acquireWriteSemaphore(id);
            OutputStream myOut = this.out;
            try {
                if (myOut == null) {
                    throw new IOException("Output stream not initialized");
                }
                byte[] ber = msg.getASN1Object().getEncoding(this.encoder);
                myOut.write(ber, 0, ber.length);
                myOut.flush();
            }
            catch (IOException ioe) {
                isConn = false;
            }
            finally {
                this.freeWriteSemaphore(id);
            }
        }
        return isConn;
    }

    final void removeMessage(Message info) {
        boolean done = this.messages.removeElement(info);
        if (done) {
            Debug.trace("Messages", this.name + "Removed Message(" + info.getMessageID() + ")");
        } else {
            Debug.trace("Messages", this.name + "Removing Message(" + info.getMessageID() + ") - not found");
        }
    }

    protected void finalize() {
        Debug.trace("Messages", this.name + "finalize: shutdown connection");
        this.shutdown("Finalize", 0, null);
    }

    private void shutdown(String reason, int semaphoreId, InterThreadException notifyUser) {
        Message info = null;
        if (!this.clientActive) {
            Debug.trace("Messages", this.name + "shutdown: already shutdown - " + reason);
            return;
        }
        Debug.trace("Messages", this.name + "shutdown: Shutting down connection - " + reason);
        this.clientActive = false;
        while (true) {
            try {
                info = (Message)this.messages.remove(0);
                Debug.trace("Messages", this.name + "Shutdown removed message(" + info.getMessageID() + ")");
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                Debug.trace("Messages", this.name + "Shutdown no messages to remove");
                break;
            }
            info.abandon(null, notifyUser);
        }
        int semId = this.acquireWriteSemaphore(semaphoreId);
        if (this.bindProperties != null && this.out != null && !this.bindProperties.isAnonymous()) {
            try {
                LDAPUnbindRequest msg = new LDAPUnbindRequest(null);
                Debug.trace("Messages", this.name + "Writing unbind request (" + msg.getMessageID() + ")");
                Debug.trace("RawInput", this.name + "RawWrite: " + msg.getASN1Object().toString());
                byte[] ber = msg.getASN1Object().getEncoding(this.encoder);
                this.out.write(ber, 0, ber.length);
                this.out.flush();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.bindProperties = null;
        this.in = null;
        this.out = null;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ie) {
                // empty catch block
            }
            this.socket = null;
        }
        try {
            if (this.reader != Thread.currentThread()) {
                this.reader.join();
            }
            this.reader = null;
        }
        catch (InterruptedException iex) {
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        this.freeWriteSemaphore(semId);
    }

    final void setBindProperties(BindProperties bindProps) {
        this.bindProperties = bindProps;
    }

    final BindProperties getBindProperties() {
        return this.bindProperties;
    }

    final boolean areMessagesComplete() {
        Object[] messages = this.messages.getObjectArray();
        int length = messages.length;
        Debug.trace("TraceTLS", "startTLS: areMessagesComplete? MessageVector size = " + length + ", bindSemaphoreId=" + this.bindSemaphoreId);
        if (this.bindSemaphoreId != 0) {
            return false;
        }
        if (length == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            Debug.trace("TraceTLS", "startTLS: areMessagesComplete? Message[" + i + "].isComplete()=" + ((Message)messages[i]).isComplete());
            if (((Message)messages[i]).isComplete()) continue;
            return false;
        }
        return true;
    }

    final void stopReaderOnReply(int messageID) {
        Debug.trace("TraceTLS", "startTLS: stopReaderOnReply of message " + messageID);
        this.stopReaderMessageID = messageID;
    }

    final void startReader() throws LDAPException {
        Thread r = new Thread(new ReaderThread());
        r.setDaemon(true);
        r.start();
        this.waitForReader(r);
    }

    final boolean isTLS() {
        return this.nonTLSBackup != null;
    }

    final void startTLS() throws LDAPException {
        if (this.mySocketFactory == null) {
            throw new LDAPException("NO_TLS_FACTORY", 112, null);
        }
        if (!(this.mySocketFactory instanceof LDAPTLSSocketFactory)) {
            throw new LDAPException("WRONG_FACTORY", 112, null);
        }
        try {
            this.waitForReader(null);
            this.nonTLSBackup = this.socket;
            this.socket = ((LDAPTLSSocketFactory)this.mySocketFactory).createSocket(this.socket);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            Debug.trace("TraceTLS", "connection.startTLS, nonTLSBackup:" + this.nonTLSBackup + ", TLSSocket:" + this.socket + ", input:" + this.in + "," + "output:" + this.out);
        }
        catch (UnknownHostException uhe) {
            this.nonTLSBackup = null;
            throw new LDAPException("The host is unknown", 91, null, uhe);
        }
        catch (IOException ioe) {
            this.nonTLSBackup = null;
            throw new LDAPException("Could not negotiate a secure connection", 91, null, ioe);
        }
    }

    final void stopTLS() throws LDAPException {
        try {
            this.stopReaderMessageID = -98;
            this.socket.close();
            this.waitForReader(null);
            this.socket = this.nonTLSBackup;
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            Debug.trace("TraceTLS", "connection.stopTLS, nonTLSBackup:" + this.nonTLSBackup + ", TLSSocket:" + this.socket + ", input:" + this.in + "," + "output:" + this.out);
            this.stopReaderMessageID = -99;
        }
        catch (IOException ioe) {
            throw new LDAPException("STOPTLS_ERROR", 91, null, ioe);
        }
        finally {
            this.nonTLSBackup = null;
            this.startReader();
        }
    }

    final void setActiveReferral(ReferralInfo referral) {
        this.activeReferral = referral;
    }

    final ReferralInfo getActiveReferral() {
        return this.activeReferral;
    }

    final void addUnsolicitedNotificationListener(LDAPUnsolicitedNotificationListener listener) {
        this.unsolicitedListeners.add(listener);
    }

    final void removeUnsolicitedNotificationListener(LDAPUnsolicitedNotificationListener listener) {
        this.unsolicitedListeners.removeElement(listener);
    }

    private void notifyAllUnsolicitedListeners(RfcLDAPMessage message) {
        Debug.trace("Messages", this.name + "Calling all Unsolicited Message Listeners");
        LDAPExtendedResponse extendedLDAPMessage = new LDAPExtendedResponse(message);
        String notificationOID = extendedLDAPMessage.getID();
        if (notificationOID.equals("1.3.6.1.4.1.1466.20036")) {
            Debug.trace("Messages", this.name + "Received server shutdown notification!");
            this.unsolSvrShutDnNotification = true;
        }
        int numOfListeners = this.unsolicitedListeners.size();
        for (int i = 0; i < numOfListeners; ++i) {
            LDAPUnsolicitedNotificationListener listener = (LDAPUnsolicitedNotificationListener)this.unsolicitedListeners.get(i);
            LDAPExtendedResponse tempLDAPMessage = new LDAPExtendedResponse(message);
            UnsolicitedListenerThread u = new UnsolicitedListenerThread(listener, tempLDAPMessage);
            u.start();
        }
        Debug.trace("Messages", this.name + "Done calling all Unsolicited Message Listeners");
    }

    String getConnectionName() {
        return this.name;
    }

    private class UnsolicitedListenerThread
    extends Thread {
        private LDAPUnsolicitedNotificationListener listenerObj;
        private LDAPExtendedResponse unsolicitedMsg;

        UnsolicitedListenerThread(LDAPUnsolicitedNotificationListener l, LDAPExtendedResponse m) {
            this.listenerObj = l;
            this.unsolicitedMsg = m;
        }

        public final void run() {
            this.listenerObj.messageReceived(this.unsolicitedMsg);
        }
    }

    public class ReaderThread
    implements Runnable {
        private ReaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void run() {
            IOException ioex;
            block19: {
                InterThreadException notify;
                String reason;
                block20: {
                    reason = "reader: thread stopping";
                    notify = null;
                    Message info = null;
                    ioex = null;
                    Connection.this.reader = Thread.currentThread();
                    Debug.trace("Messages", Connection.this.name + "reader: thread starting: " + Connection.this.reader.toString());
                    try {
                        try {}
                        catch (IOException ioe) {
                            Debug.trace("Messages", Connection.this.name + "Connection lost waiting for results from " + Connection.this.host + ":" + Connection.this.port + ", clientActive=" + Connection.this.clientActive + "\n\t" + ioe.toString());
                            ioex = ioe;
                            if (Connection.this.stopReaderMessageID != -98 && Connection.this.clientActive) {
                                notify = new InterThreadException("CONNECTION_WAIT", new Object[]{Connection.this.host, new Integer(Connection.this.port)}, 91, ioe, info);
                            }
                            Connection.this.in = null;
                            Connection.this.out = null;
                            Object var13_16 = null;
                            Debug.trace("Messages", Connection.this.name + "reader: connection shutdown");
                            if (!Connection.this.clientActive || notify != null) {
                                Connection.this.shutdown(reason, 0, notify);
                                break block19;
                            } else {
                                Connection.this.stopReaderMessageID = -99;
                                Debug.trace("TraceTLS", "reader: Stopping thread, retaining the connection");
                            }
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_17 = null;
                        Debug.trace("Messages", Connection.this.name + "reader: connection shutdown");
                        if (Connection.this.clientActive && notify == null) {
                            Connection.this.stopReaderMessageID = -99;
                            Debug.trace("TraceTLS", "reader: Stopping thread, retaining the connection");
                            throw throwable;
                        }
                        Connection.this.shutdown(reason, 0, notify);
                        throw throwable;
                    }
                    while (true) {
                        InputStream myIn;
                        if ((myIn = Connection.this.in) == null) break block20;
                        ASN1Identifier asn1ID = new ASN1Identifier(myIn);
                        int tag = asn1ID.getTag();
                        if (asn1ID.getTag() != 16) {
                            Debug.trace("Messages", Connection.this.name + "reader: discarding message with tag " + tag);
                            continue;
                        }
                        ASN1Length asn1Len = new ASN1Length(myIn);
                        RfcLDAPMessage msg = new RfcLDAPMessage(Connection.this.decoder, myIn, asn1Len.getLength());
                        Debug.trace("RawInput", Connection.this.name + "RawRead: " + msg.toString());
                        int msgId = msg.getMessageID();
                        try {
                            info = Connection.this.messages.findMessageById(msgId);
                            Debug.trace("Messages", Connection.this.name + "reader: queue response to message(" + msgId + ")");
                            info.putReply(msg);
                        }
                        catch (NoSuchFieldException ex) {
                            if (msgId == 0) {
                                Debug.trace("Messages", Connection.this.name + "Received message id 0");
                                Connection.this.notifyAllUnsolicitedListeners(msg);
                                if (Connection.this.unsolSvrShutDnNotification) {
                                    notify = new InterThreadException("SERVER_SHUTDOWN_REQ", new Object[]{Connection.this.host, new Integer(Connection.this.port)}, 91, null, null);
                                    Object var13_13 = null;
                                    Debug.trace("Messages", Connection.this.name + "reader: connection shutdown");
                                    if (Connection.this.clientActive && notify == null) {
                                        Connection.this.stopReaderMessageID = -99;
                                        Debug.trace("TraceTLS", "reader: Stopping thread, retaining the connection");
                                        return;
                                    }
                                    Connection.this.shutdown(reason, 0, notify);
                                    return;
                                }
                            }
                            Debug.trace("Messages", Connection.this.name + "reader: message(" + msgId + ") not found, discarding reply");
                        }
                        if (Connection.this.stopReaderMessageID == msgId) break;
                        if (Connection.this.stopReaderMessageID == -98) break;
                    }
                    Object var13_14 = null;
                    Debug.trace("Messages", Connection.this.name + "reader: connection shutdown");
                    if (!Connection.this.clientActive || notify != null) {
                        Connection.this.shutdown(reason, 0, notify);
                        return;
                    }
                    Connection.this.stopReaderMessageID = -99;
                    Debug.trace("TraceTLS", "reader: Stopping thread, retaining the connection");
                    return;
                }
                Debug.trace("Messages", Connection.this.name + "reader: thread stopping, connection shut down");
                Object var13_15 = null;
                Debug.trace("Messages", Connection.this.name + "reader: connection shutdown");
                if (!Connection.this.clientActive || notify != null) {
                    Connection.this.shutdown(reason, 0, notify);
                } else {
                    Connection.this.stopReaderMessageID = -99;
                    Debug.trace("TraceTLS", "reader: Stopping thread, retaining the connection");
                }
            }
            Connection.this.deadReaderException = ioex;
            Connection.this.deadReader = Connection.this.reader;
            Connection.this.reader = null;
            Debug.trace("Messages", Connection.this.name + "reader: thread terminated");
        }
    }
}

