/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.user;

import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.persistence.datasource.model.identifier.UuidIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.SilverpeasJpaEntity;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.user.Replacement;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.engine.WorkflowHub;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

@NamedQueries(value={@NamedQuery(name="Replacement.findAllByIncumbentAndByWorkflow", query="select r from ReplacementImpl r where r.incumbentId = :incumbent and r.workflowId = :workflow"), @NamedQuery(name="Replacement.findAllBySubstituteAndByWorkflow", query="select r from ReplacementImpl r where r.substituteId = :substitute and r.workflowId = :workflow"), @NamedQuery(name="Replacement.findAllByWorkflow", query="select r from ReplacementImpl r where r.workflowId = :workflow"), @NamedQuery(name="Replacement.findAllByUsersAndByWorkflow", query="select r from ReplacementImpl r where r.incumbentId = :incumbent and r.substituteId = :substitute and r.workflowId = :workflow")})
@Entity
@Table(name="sb_workflow_replacements")
public class ReplacementImpl
extends SilverpeasJpaEntity<ReplacementImpl, UuidIdentifier>
implements Replacement<ReplacementImpl> {
    @NotNull
    @Column(nullable=false)
    private String incumbentId;
    @NotNull
    @Column(nullable=false)
    private String substituteId;
    @NotNull
    @Column(nullable=false)
    private String workflowId;
    @NotNull
    @Column(nullable=false)
    private LocalDate startDate;
    @NotNull
    @Column(nullable=false)
    private LocalDate endDate;

    @Override
    public User getIncumbent() {
        return this.getWorkflowUser(this.incumbentId);
    }

    @Override
    public User getSubstitute() {
        return this.getWorkflowUser(this.substituteId);
    }

    @Override
    public Period getPeriod() {
        return Period.between((LocalDate)this.startDate, (LocalDate)this.endDate);
    }

    @Override
    public String getWorkflowInstanceId() {
        return this.workflowId;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    ReplacementImpl setIncumbent(User incumbent) {
        Objects.requireNonNull(incumbent, "The user to replace must be non-null");
        this.requireDifferentUsers(incumbent.getUserId(), this.substituteId);
        this.incumbentId = incumbent.getUserId();
        return this;
    }

    public ReplacementImpl setSubstitute(User substitute) {
        Objects.requireNonNull(substitute, "The user who replaces the incumbent must be non-null");
        this.requireDifferentUsers(this.incumbentId, substitute.getUserId());
        this.substituteId = substitute.getUserId();
        return this;
    }

    ReplacementImpl setWorkflowId(String workflowId) {
        StringUtil.requireDefined((String)workflowId, (String)"The unique identifier of the workflow instance must be non-null");
        this.workflowId = workflowId;
        return this;
    }

    public ReplacementImpl setPeriod(Period period) {
        Objects.requireNonNull(period, "The period during which the replacement is enabled must be non-null");
        this.startDate = TemporalConverter.asLocalDate((Temporal)period.getStartDate());
        this.endDate = TemporalConverter.asLocalDate((Temporal)period.getEndDate());
        return this;
    }

    private User getWorkflowUser(String userId) {
        try {
            return WorkflowHub.getUserManager().getUser(userId);
        }
        catch (WorkflowException e) {
            throw new SilverpeasRuntimeException((Throwable)((Object)e));
        }
    }

    private void requireDifferentUsers(String incumbentId, String substituteId) {
        if (StringUtil.isDefined((String)incumbentId) && StringUtil.isDefined((String)substituteId) && incumbentId.equals(substituteId)) {
            throw new IllegalArgumentException("A user cannot be replaced by himself");
        }
    }
}

