/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.instance;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueIntegerIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.workflow.api.Workflow;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.instance.Question;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.engine.instance.ProcessInstanceImpl;

@Entity
@Table(name="sb_workflow_question")
public class QuestionImpl
extends BasicJpaEntity<QuestionImpl, UniqueIntegerIdentifier>
implements Question {
    @ManyToOne
    @JoinColumn(name="instanceid", nullable=false)
    private ProcessInstanceImpl processInstance = null;
    @Column
    private String fromState = null;
    @Column
    private String targetState = null;
    @Column
    private String questionText = null;
    @Column
    private String responseText = null;
    @Column
    private Date questionDate = null;
    @Column
    private Date responseDate = null;
    @Column
    private int relevant = 1;
    @Column
    private String fromUserId = null;
    @Column
    private String toUserId = null;

    protected QuestionImpl() {
    }

    public QuestionImpl(ProcessInstance processInstance, String questionText, String fromState, String targetState, User fromUser, User toUser) {
        this.processInstance = (ProcessInstanceImpl)processInstance;
        this.questionText = questionText;
        this.fromState = fromState;
        this.targetState = targetState;
        this.questionDate = new Date();
        this.fromUserId = fromUser.getUserId();
        this.toUserId = toUser.getUserId();
    }

    @Override
    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = (ProcessInstanceImpl)processInstance;
    }

    public String getFromStateName() {
        return this.fromState;
    }

    @Override
    public State getFromState() {
        if (this.processInstance == null) {
            return null;
        }
        try {
            return this.processInstance.getProcessModel().getState(this.fromState);
        }
        catch (WorkflowException e) {
            return null;
        }
    }

    public void setFromStateName(String fromState) {
        this.fromState = fromState;
    }

    public String getTargetStateName() {
        return this.targetState;
    }

    @Override
    public State getTargetState() {
        if (this.processInstance == null) {
            return null;
        }
        try {
            return this.processInstance.getProcessModel().getState(this.targetState);
        }
        catch (WorkflowException e) {
            return null;
        }
    }

    public void setTargetStateName(String targetState) {
        this.targetState = targetState;
    }

    @Override
    public String getQuestionText() {
        return this.questionText;
    }

    public void setQuestionText(String questionText) {
        this.questionText = questionText;
    }

    @Override
    public String getResponseText() {
        return this.responseText;
    }

    public void setResponseText(String responseText) {
        this.responseText = responseText;
    }

    @Override
    public void answer(String responseText) {
        this.responseText = responseText;
        this.responseDate = new Date();
    }

    public void setFromUserId(String fromUserId) {
        this.fromUserId = fromUserId;
    }

    public String getFromUserId() {
        return this.fromUserId;
    }

    @Override
    public User getFromUser() throws WorkflowException {
        return Workflow.getUserManager().getUser(this.fromUserId);
    }

    public void setToUserId(String toUserId) {
        this.toUserId = toUserId;
    }

    public String getToUserId() {
        return this.toUserId;
    }

    @Override
    public User getToUser() throws WorkflowException {
        return Workflow.getUserManager().getUser(this.toUserId);
    }

    @Override
    public Date getQuestionDate() {
        return this.questionDate;
    }

    public void setQuestionDate(Date questionDate) {
        this.questionDate = questionDate;
    }

    @Override
    public Date getResponseDate() {
        return this.responseDate;
    }

    public void setResponseDate(Date responseDate) {
        this.responseDate = responseDate;
    }

    @Override
    public boolean hasResponse() {
        return this.responseText != null;
    }

    @Override
    public boolean isRelevant() {
        return this.relevant == 1;
    }

    public void setRelevant(boolean relevant) {
        this.relevant = relevant ? 1 : 0;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

