/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.datarecord;

import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.field.TextFieldImpl;
import org.silverpeas.core.workflow.api.Workflow;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.instance.HistoryStep;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.model.Item;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.api.user.UserInfo;
import org.silverpeas.core.workflow.api.user.UserSettings;
import org.silverpeas.core.workflow.engine.datarecord.ProcessInstanceFieldTemplate;
import org.silverpeas.core.workflow.engine.user.UserSettingsService;

public class UserInfoTemplate
extends ProcessInstanceFieldTemplate {
    private final String role;
    private final String lang;
    private final Item item;

    public UserInfoTemplate(String fieldName, Item item, String role, String lang) {
        super(fieldName, item.getType(), item.getType(), item.getLabel(role, lang));
        this.role = role;
        this.lang = lang;
        this.item = item;
    }

    @Override
    public Field getField(ProcessInstance instance) throws FormException {
        TextFieldImpl field = null;
        try {
            String shortFieldName = this.getFieldName();
            int index = shortFieldName.lastIndexOf(".actor.");
            String actionName = shortFieldName.substring(7, index);
            HistoryStep step = instance.getMostRecentStep(actionName);
            if (step != null) {
                shortFieldName = shortFieldName.substring(index + 7);
                if (this.item.getMapTo() != null && !this.item.getMapTo().isEmpty()) {
                    User user = Workflow.getUserManager().getUser(step.getUser().getUserId());
                    field = new TextFieldImpl();
                    if (user != null) {
                        field.setStringValue(user.getInfo(this.item.getMapTo()));
                    }
                } else {
                    UserSettings settings = UserSettingsService.get().get(step.getUser().getUserId(), instance.getModelId());
                    UserInfo info = settings.getUserInfo(shortFieldName);
                    field = instance.getProcessModel().getUserInfos().toRecordTemplate(this.role, this.lang, false).getEmptyRecord().getField(shortFieldName);
                    if (field != null && info != null) {
                        field.setStringValue(info.getValue());
                    }
                }
            }
            return field;
        }
        catch (WorkflowException e) {
            throw new FormException("Unknown field " + this.getFieldName(), new String[0]);
        }
    }
}

