/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.organizationchart.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.silverpeas.components.organizationchart.model.OrganizationalChart;
import org.silverpeas.components.organizationchart.model.OrganizationalChartType;
import org.silverpeas.components.organizationchart.model.OrganizationalPerson;
import org.silverpeas.components.organizationchart.model.OrganizationalPersonComparator;
import org.silverpeas.components.organizationchart.model.OrganizationalUnit;
import org.silverpeas.components.organizationchart.model.PersonCategory;
import org.silverpeas.components.organizationchart.service.AbstractOrganizationChartBuilder;
import org.silverpeas.components.organizationchart.service.LdapOrganizationChartConfiguration;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

class LdapOrganizationChartBuilder
extends AbstractOrganizationChartBuilder {
    private static final String OBJECT_CLASS = "(objectclass=";
    private final LdapOrganizationChartConfiguration config;

    static LdapOrganizationChartBuilder from(LdapOrganizationChartConfiguration config) {
        return new LdapOrganizationChartBuilder(config);
    }

    private LdapOrganizationChartBuilder(LdapOrganizationChartConfiguration config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OrganizationalChart buildFor(String baseOu, OrganizationalChartType type) {
        OrganizationalChart chart;
        Map<String, String> env = this.config.getEnv();
        List<OrganizationalPerson> ouMembers = null;
        List<OrganizationalUnit> units = null;
        String rootOu = StringUtil.isDefined((String)baseOu) ? baseOu : this.config.getRoot();
        String[] ous = rootOu.split(",");
        String[] firstOu = ous[0].split("=");
        OrganizationalUnit parent = new OrganizationalUnit(firstOu[1], rootOu);
        this.setParents(parent, this.config.getAttUnit(), rootOu);
        Context ctx = null;
        try {
            ctx = new InitialDirContext(new Hashtable<String, String>(env));
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(1);
            ctls.setCountLimit(0L);
            if (StringUtil.isDefined((String)this.config.getLdapAttCSSClass())) {
                OrganizationalUnit root = this.getOrganizationalUnit((DirContext)ctx, rootOu);
                String cssClass = this.getSpecificCSSClass((DirContext)ctx, root);
                parent.setSpecificCSSClass(cssClass);
                parent.setDetail(root.getDetail());
            }
            parent.setHasMembers((ouMembers = this.getOUMembers((DirContext)ctx, ctls, rootOu, type)).size() > 1);
            if (type == OrganizationalChartType.TYPE_UNITCHART) {
                units = this.getSubOrganizationUnits((DirContext)ctx, ctls, rootOu);
            }
        }
        catch (NamingException e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            OrganizationalChart root = null;
            return root;
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        boolean silverpeasUserLinkable = StringUtil.isDefined((String)this.config.getDomainId());
        if (type == OrganizationalChartType.TYPE_UNITCHART) {
            chart = new OrganizationalChart(parent, units, ouMembers, silverpeasUserLinkable);
        } else {
            Set<PersonCategory> categories = this.getCategories(ouMembers);
            chart = new OrganizationalChart(parent, ouMembers, categories, silverpeasUserLinkable);
        }
        return chart;
    }

    private boolean isRoot(String ou) {
        return !StringUtil.isDefined((String)ou) || ou.equalsIgnoreCase(this.config.getRoot());
    }

    private void setParents(OrganizationalUnit unit, String ou, String baseOu) {
        String[] values;
        if (this.isRoot(baseOu)) {
            return;
        }
        String parentName = null;
        String[] ous = unit.getCompleteName().split(",");
        if (ous.length > 1 && (values = ous[1].split("=")).length > 1 && values[0].equalsIgnoreCase(ou)) {
            parentName = values[1];
        }
        unit.setParentName(parentName);
        if (parentName != null) {
            int indexStart = unit.getCompleteName().toUpperCase().lastIndexOf(ou.toUpperCase() + "=" + parentName.toUpperCase());
            String parentOu = unit.getCompleteName().substring(indexStart);
            unit.setParentOu(parentOu);
        }
    }

    private OrganizationalUnit getParentOU(String ou) {
        String parentOu = ou.substring(ou.indexOf(44) + 1);
        String parentName = parentOu.substring(3, parentOu.indexOf(44));
        return new OrganizationalUnit(parentName, parentOu);
    }

    private List<OrganizationalPerson> getOUMembers(DirContext ctx, SearchControls ctls, String rootOu, OrganizationalChartType type) throws NamingException {
        ArrayList<OrganizationalPerson> personList = new ArrayList<OrganizationalPerson>();
        NamingEnumeration<SearchResult> results = ctx.search(rootOu, OBJECT_CLASS + this.config.getLdapClassPerson() + ")", ctls);
        int i = 0;
        while (results != null && results.hasMore()) {
            SearchResult entry = results.next();
            if (!StringUtil.isDefined((String)entry.getName())) continue;
            Attributes attrs = entry.getAttributes();
            if (!this.isUserActive(this.config.getLdapAttActif(), attrs)) continue;
            OrganizationalPerson person = this.loadOrganizationalPerson(i, attrs, entry.getNameInNamespace(), type);
            personList.add(person);
            ++i;
        }
        Collections.sort(personList, new OrganizationalPersonComparator());
        return personList;
    }

    private List<OrganizationalUnit> getSubOrganizationUnits(DirContext ctx, SearchControls ctls, String rootOu) throws NamingException {
        ArrayList<OrganizationalUnit> units = new ArrayList<OrganizationalUnit>();
        NamingEnumeration<SearchResult> results = ctx.search(rootOu, OBJECT_CLASS + this.config.getLdapClassUnit() + ")", ctls);
        while (results != null && results.hasMore()) {
            SearchResult entry = results.next();
            Attributes attrs = entry.getAttributes();
            String ou = this.getFirstAttributeValue(attrs.get(this.config.getAttUnit()));
            String completeOu = entry.getNameInNamespace();
            OrganizationalUnit unit = new OrganizationalUnit(ou, completeOu);
            this.setParents(unit, this.config.getAttUnit(), completeOu);
            Map<String, String> attributesToReturn = this.config.getUnitsChartOthersInfosKeys();
            Map<String, String> details = this.getDetails(attributesToReturn, attrs);
            unit.setDetail(details);
            if (StringUtil.isDefined((String)this.config.getLdapAttCSSClass())) {
                unit.setSpecificCSSClass(this.getFirstAttributeValue(attrs.get(this.config.getLdapAttCSSClass())));
            }
            units.add(unit);
        }
        for (OrganizationalUnit unit : units) {
            boolean hasSubOrganizations = this.hasResults(unit.getCompleteName(), OBJECT_CLASS + this.config.getLdapClassUnit() + ")", ctx, ctls);
            unit.setHasSubUnits(hasSubOrganizations);
            try {
                List<OrganizationalPerson> users = this.getOUMembers(ctx, ctls, unit.getCompleteName(), OrganizationalChartType.TYPE_UNITCHART);
                List<OrganizationalPerson> mainActors = this.getMainActors(users);
                unit.setMainActors(mainActors);
                unit.setHasMembers(users.size() > mainActors.size());
                if (!StringUtil.isDefined((String)this.config.getLdapAttCSSClass())) continue;
                String cssClass = this.getSpecificCSSClass(ctx, unit);
                unit.setSpecificCSSClass(cssClass);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("cannot get organization unit of dn ''{0}'' ({1})", (Object[])new String[]{unit.getCompleteName(), e.getLocalizedMessage()}, (Throwable)e);
            }
        }
        return units;
    }

    private OrganizationalUnit getOrganizationalUnit(DirContext ctx, String rootOu) throws NamingException {
        Attributes attrs = ctx.getAttributes(rootOu);
        String ou = this.getFirstAttributeValue(attrs.get(this.config.getAttUnit()));
        OrganizationalUnit unit = new OrganizationalUnit(ou, rootOu);
        if (StringUtil.isDefined((String)this.config.getLdapAttCSSClass())) {
            unit.setSpecificCSSClass(this.getFirstAttributeValue(attrs.get(this.config.getLdapAttCSSClass())));
        }
        Map<String, String> attributesToReturn = this.config.getUnitsChartOthersInfosKeys();
        Map<String, String> details = this.getDetails(attributesToReturn, attrs);
        unit.setDetail(details);
        return unit;
    }

    private String getSpecificCSSClass(DirContext ctx, OrganizationalUnit unit) throws NamingException {
        String cssClass = unit.getSpecificCSSClass();
        if (!StringUtil.isDefined((String)cssClass) && !this.isRoot(unit.getCompleteName())) {
            String ou = unit.getCompleteName();
            while (StringUtil.isDefined((String)ou) && !StringUtil.isDefined((String)cssClass) && !this.isRoot(ou)) {
                OrganizationalUnit parent = this.getParentOU(ou);
                if (parent.getCompleteName() != null) {
                    OrganizationalUnit fullParent = this.getOrganizationalUnit(ctx, parent.getCompleteName());
                    cssClass = fullParent.getSpecificCSSClass();
                    ou = parent.getCompleteName();
                    continue;
                }
                ou = "";
            }
        }
        return cssClass;
    }

    private boolean hasResults(String baseDN, String filter, DirContext ctx, SearchControls ctls) throws NamingException {
        NamingEnumeration<SearchResult> results = this.getResults(baseDN, filter, ctx, ctls);
        return results != null && results.hasMoreElements();
    }

    private NamingEnumeration<SearchResult> getResults(String baseDN, String filter, DirContext ctx, SearchControls ctls) throws NamingException {
        return ctx.search(baseDN, filter, ctls);
    }

    private OrganizationalPerson loadOrganizationalPerson(int id, Attributes attrs, String dn, OrganizationalChartType type) {
        String service;
        String login;
        String description;
        String function;
        String fullName;
        block7: {
            fullName = this.getFirstAttributeValue(attrs.get(this.config.getAttName()));
            function = this.getFirstAttributeValue(attrs.get(this.config.getAttTitle()));
            description = this.getFirstAttributeValue(attrs.get(this.config.getAttDesc()));
            login = this.getFirstAttributeValue(attrs.get(this.config.getLdapAttAccount()));
            service = this.getFirstAttributeValue(attrs.get(this.config.getAttUnit()));
            try {
                if (service != null) break block7;
                LdapName ldapName = new LdapName(dn);
                for (Rdn rdn : ldapName.getRdns()) {
                    if (!rdn.getType().equalsIgnoreCase("ou")) continue;
                    service = rdn.getValue().toString();
                    break;
                }
            }
            catch (InvalidNameException e1) {
                SilverLogger.getLogger((Object)this).error("cannot load organizational person from dn ''{0}'' ({1})", (Object[])new String[]{dn, e1.getLocalizedMessage()}, (Throwable)e1);
            }
        }
        OrganizationalPerson person = new OrganizationalPerson(id, -1, fullName, function, description, service, login);
        Map<String, String> attributesToReturn = type == OrganizationalChartType.TYPE_UNITCHART ? this.config.getUnitsChartOthersInfosKeys() : this.config.getPersonnsChartOthersInfosKeys();
        Map<String, String> details = this.getDetails(attributesToReturn, attrs);
        person.setDetail(details);
        if (function != null) {
            if (type == OrganizationalChartType.TYPE_UNITCHART) {
                this.defineUnitChartRoles(person, function, this.config);
            } else {
                this.defineDetailledChartRoles(person, function, this.config);
            }
        } else {
            person.setVisibleCategory(new PersonCategory("Personnel"));
        }
        return person;
    }

    private Map<String, String> getDetails(Map<String, String> attributesToReturn, Attributes attrs) {
        HashMap<String, String> details = new HashMap<String, String>();
        for (Map.Entry<String, String> attribute : attributesToReturn.entrySet()) {
            Attribute att = attrs.get(attribute.getKey());
            if (att == null) continue;
            try {
                String detail;
                if (att.size() > 1) {
                    String listOfVals = this.getListOfValues(att);
                    detail = listOfVals.substring(0, listOfVals.length() - 2);
                } else {
                    detail = this.getFirstAttributeValue(att);
                }
                if (detail != null) {
                    detail = this.escapeHTML(detail);
                }
                details.put(attribute.getValue(), detail);
            }
            catch (NamingException e) {
                SilverLogger.getLogger((Object)this).error("cannot get data of attribute ''{0}'' ({1})", (Object[])new String[]{attribute.getKey(), e.getLocalizedMessage()}, (Throwable)e);
            }
        }
        return details;
    }

    private String getListOfValues(Attribute att) throws NamingException {
        StringBuilder listOfVals = new StringBuilder();
        NamingEnumeration<?> vals = att.getAll();
        while (vals.hasMore()) {
            String val = (String)vals.next();
            listOfVals.append(val).append(", ");
        }
        return listOfVals.toString();
    }

    private String escapeHTML(String s) {
        StringBuilder sb = new StringBuilder();
        int n = s.length();
        block9: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block9;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block9;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block9;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block9;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block9;
                }
                case '/': {
                    sb.append("&#47;");
                    continue block9;
                }
                case '\\': {
                    sb.append("&#92;");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private String getFirstAttributeValue(Attribute att) {
        String result = null;
        try {
            String val;
            if (att != null && StringUtil.isDefined((String)(val = (String)att.get()))) {
                result = val;
            }
        }
        catch (NamingException e1) {
            SilverLogger.getLogger((Object)this).error("cannot get first value of attribute ''{0}'' ({1})", (Object[])new String[]{att.getID(), e1.getLocalizedMessage()}, (Throwable)e1);
        }
        return result;
    }

    private boolean isUserActive(String activeAttribute, Attributes attrs) {
        if (activeAttribute == null) {
            return true;
        }
        String actif = this.getFirstAttributeValue(attrs.get(activeAttribute));
        return StringUtil.getBooleanValue((String)actif);
    }
}

