/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import java.security.Principal;
import java.util.Iterator;
import java.util.Objects;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.jcr.delegate.GroupDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.UserDelegator;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AuthorizableDelegator
implements Authorizable {
    final SessionDelegate sessionDelegate;
    final Authorizable delegate;

    AuthorizableDelegator(@NotNull SessionDelegate sessionDelegate, @NotNull Authorizable delegate) {
        Validate.checkArgument((!(delegate instanceof AuthorizableDelegator) ? 1 : 0) != 0);
        this.sessionDelegate = sessionDelegate;
        this.delegate = delegate;
    }

    @Nullable
    static Authorizable wrap(@NotNull SessionDelegate sessionDelegate, @Nullable Authorizable authorizable) {
        if (authorizable == null) {
            return null;
        }
        if (authorizable.isGroup()) {
            return GroupDelegator.wrap(sessionDelegate, (Group)authorizable);
        }
        return UserDelegator.wrap(sessionDelegate, (User)authorizable);
    }

    @NotNull
    static Authorizable unwrap(@NotNull Authorizable authorizable) {
        if (authorizable.isGroup()) {
            return GroupDelegator.unwrap((Group)authorizable);
        }
        return UserDelegator.unwrap((User)authorizable);
    }

    public boolean isGroup() {
        return this.sessionDelegate.safePerform(new SessionOperation<Boolean>("isGroup"){

            @Override
            @NotNull
            public Boolean perform() {
                return AuthorizableDelegator.this.delegate.isGroup();
            }
        });
    }

    @NotNull
    public String getID() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<String>("getID"){

            @Override
            @NotNull
            public String perform() throws RepositoryException {
                return AuthorizableDelegator.this.delegate.getID();
            }
        });
    }

    @NotNull
    public Principal getPrincipal() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Principal>("getPrincipal"){

            @Override
            @NotNull
            public Principal perform() throws RepositoryException {
                return AuthorizableDelegator.this.delegate.getPrincipal();
            }
        });
    }

    @NotNull
    public Iterator<Group> declaredMemberOf() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Iterator<Group>>("declaredMemberOf"){

            @Override
            @NotNull
            public Iterator<Group> perform() throws RepositoryException {
                Iterator groups = AuthorizableDelegator.this.delegate.declaredMemberOf();
                return IteratorUtils.transform((Iterator)IteratorUtils.filter((Iterator)groups, Objects::nonNull), group -> GroupDelegator.wrap(AuthorizableDelegator.this.sessionDelegate, group));
            }
        });
    }

    @NotNull
    public Iterator<Group> memberOf() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Iterator<Group>>("memberOf"){

            @Override
            @NotNull
            public Iterator<Group> perform() throws RepositoryException {
                Iterator groups = AuthorizableDelegator.this.delegate.memberOf();
                return IteratorUtils.transform((Iterator)IteratorUtils.filter((Iterator)groups, Objects::nonNull), group -> GroupDelegator.wrap(AuthorizableDelegator.this.sessionDelegate, group));
            }
        });
    }

    public void remove() throws RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("remove", true){

            @Override
            public void performVoid() throws RepositoryException {
                AuthorizableDelegator.this.delegate.remove();
            }
        });
    }

    @NotNull
    public Iterator<String> getPropertyNames() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Iterator<String>>("getPropertyNames"){

            @Override
            @NotNull
            public Iterator<String> perform() throws RepositoryException {
                return AuthorizableDelegator.this.delegate.getPropertyNames();
            }
        });
    }

    @NotNull
    public Iterator<String> getPropertyNames(final @NotNull String relPath) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Iterator<String>>("getPropertyNames"){

            @Override
            @NotNull
            public Iterator<String> perform() throws RepositoryException {
                return AuthorizableDelegator.this.delegate.getPropertyNames(relPath);
            }
        });
    }

    public boolean hasProperty(final @NotNull String relPath) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("hasProperty"){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return AuthorizableDelegator.this.delegate.hasProperty(relPath);
            }
        });
    }

    public void setProperty(final @NotNull String relPath, final @Nullable Value value) throws RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("setProperty", true){

            @Override
            public void performVoid() throws RepositoryException {
                AuthorizableDelegator.this.delegate.setProperty(relPath, value);
            }
        });
    }

    public void setProperty(final @NotNull String relPath, final @Nullable Value[] value) throws RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("setProperty", true){

            @Override
            public void performVoid() throws RepositoryException {
                AuthorizableDelegator.this.delegate.setProperty(relPath, value);
            }
        });
    }

    @Nullable
    public Value[] getProperty(final @NotNull String relPath) throws RepositoryException {
        return this.sessionDelegate.performNullable(new SessionOperation<Value[]>("getProperty"){

            @Override
            public Value[] performNullable() throws RepositoryException {
                return AuthorizableDelegator.this.delegate.getProperty(relPath);
            }
        });
    }

    public boolean removeProperty(final @NotNull String relPath) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("removeProperty", true){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return AuthorizableDelegator.this.delegate.removeProperty(relPath);
            }
        });
    }

    @NotNull
    public String getPath() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<String>("getPath"){

            @Override
            @NotNull
            public String perform() throws RepositoryException {
                return AuthorizableDelegator.this.delegate.getPath();
            }
        });
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof AuthorizableDelegator) {
            AuthorizableDelegator ad = (AuthorizableDelegator)other;
            return this.delegate.equals(ad.delegate);
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

