/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.report;

import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.importexport.report.MassiveReport;
import org.silverpeas.core.importexport.report.UnitReport;

public class ComponentReport {
    private String componentId;
    private String componentName;
    private int nbPublicationsCreated = -1;
    private int nbPublicationsUpdated = -1;
    private int nbTopicsCreated = -1;
    private long totalImportedFileSize = 0L;
    private List<MassiveReport> listMassiveReports = new ArrayList<MassiveReport>();
    private List<UnitReport> listUnitReports = new ArrayList<UnitReport>();

    public ComponentReport(String componentId) {
        this.componentId = componentId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void addUnitReport(UnitReport report) {
        this.listUnitReports.add(report);
    }

    public void addMassiveReport(MassiveReport report) {
        this.listMassiveReports.add(report);
        report.setComponentReport(this);
    }

    public int getNbPublicationsCreated() {
        if (this.nbPublicationsCreated == -1) {
            this.processStats();
        }
        return this.nbPublicationsCreated;
    }

    public int getNbTopicsCreated() {
        if (this.nbTopicsCreated == -1) {
            this.processStats();
        }
        return this.nbTopicsCreated;
    }

    public void setComponentId(String string) {
        this.componentId = string;
    }

    public void setComponentName(String string) {
        this.componentName = string;
    }

    public void setNbTopicsCreated(int i) {
        this.nbTopicsCreated = i;
    }

    public List<MassiveReport> getListMassiveReports() {
        return this.listMassiveReports;
    }

    public List<UnitReport> getListUnitReports() {
        return this.listUnitReports;
    }

    public int getNbPublicationsUpdated() {
        if (this.nbPublicationsUpdated == -1) {
            this.processStats();
        }
        return this.nbPublicationsUpdated;
    }

    public void setNbPublicationsCreated(int nbPublicationsCreated) {
        this.nbPublicationsCreated = nbPublicationsCreated;
    }

    public void setNbPublicationsUpdated(int nbPublicationsUpdated) {
        this.nbPublicationsUpdated = nbPublicationsUpdated;
    }

    public void processStats() {
        this.nbPublicationsCreated = 0;
        this.nbPublicationsUpdated = 0;
        this.nbTopicsCreated = 0;
        for (UnitReport unitReport : this.listUnitReports) {
            switch (unitReport.getStatus()) {
                case 0: {
                    ++this.nbPublicationsCreated;
                    break;
                }
                case 1: {
                    ++this.nbPublicationsUpdated;
                    break;
                }
                case 2: {
                    ++this.nbTopicsCreated;
                }
            }
        }
        for (MassiveReport massiveReport : this.listMassiveReports) {
            this.nbPublicationsCreated += massiveReport.getNbPublicationsCreated();
            this.nbPublicationsUpdated += massiveReport.getNbPublicationsUpdated();
            this.nbTopicsCreated += massiveReport.getNbTopicsCreated();
        }
    }

    public void addImportedFileSize(long size) {
        this.totalImportedFileSize += size;
    }

    public long getTotalImportedFileSize() {
        return this.totalImportedFileSize;
    }
}

