/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.control;

import java.lang.annotation.Annotation;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.importexport.control.GEDImportExport;
import org.silverpeas.core.importexport.control.ImportExportFactory;
import org.silverpeas.core.importexport.control.ImportExportHelper;
import org.silverpeas.core.importexport.control.ImportSettings;
import org.silverpeas.core.importexport.control.RepositoriesTypeManager;
import org.silverpeas.core.importexport.model.ImportExportException;
import org.silverpeas.core.importexport.report.ImportReport;
import org.silverpeas.core.importexport.report.ImportReportManager;
import org.silverpeas.core.importexport.report.MassiveReport;
import org.silverpeas.core.pdc.pdc.importexport.PdcImportExport;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.file.FileFolderManager;

@Service
public class MassiveDocumentImport {
    @Inject
    private PdcImportExport pdcImportExport;
    @Inject
    private RepositoriesTypeManager repositoriesTypeManager;

    public static MassiveDocumentImport get() {
        return (MassiveDocumentImport)ServiceProvider.getService(MassiveDocumentImport.class, (Annotation[])new Annotation[0]);
    }

    protected MassiveDocumentImport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportReport importDocuments(ImportSettings importSettings, MassiveReport massiveReport) throws ImportExportException {
        ImportReportManager reportManager = new ImportReportManager();
        try {
            massiveReport.setRepositoryPath(importSettings.getPathToImport());
            reportManager.addMassiveReport(massiveReport, importSettings.getComponentId());
            GEDImportExport gedIE = ImportExportFactory.createGEDImportExport(importSettings.getUser(), importSettings.getComponentId());
            importSettings.setVersioningUsed(ImportExportHelper.isVersioningUsed(importSettings.getComponentId()));
            this.repositoriesTypeManager.processImportRecursiveReplicate(reportManager, massiveReport, gedIE, this.pdcImportExport, importSettings);
            reportManager.reportImportEnd();
        }
        finally {
            FileFolderManager.deleteFolder((String)importSettings.getPathToImport());
        }
        return reportManager.getImportReport();
    }
}

