/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.pdc.service;

import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityNotFoundException;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.contentcontainer.content.SilverpeasContentManager;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.SilverpeasContent;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.PdcAxisValue;
import org.silverpeas.core.pdc.pdc.model.PdcClassification;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.model.PdcPosition;
import org.silverpeas.core.pdc.pdc.model.PdcRuntimeException;
import org.silverpeas.core.pdc.pdc.service.PdcAxisValueRepository;
import org.silverpeas.core.pdc.pdc.service.PdcClassificationRepository;
import org.silverpeas.core.pdc.pdc.service.PdcClassificationService;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.persistence.datasource.model.jpa.AbstractJpaEntity;
import org.silverpeas.kernel.exception.NotSupportedException;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Transactional
@Singleton
public class DefaultPdcClassificationService
implements PdcClassificationService,
ComponentInstanceDeletion {
    @Inject
    private PdcClassificationRepository classificationRepository;
    @Inject
    private PdcAxisValueRepository valueRepository;
    @Inject
    private NodeService nodeService;

    @Override
    public PdcClassification findAPreDefinedClassification(String nodeId, String instanceId) {
        try {
            PdcClassification classification = null;
            if (StringUtil.isDefined((String)nodeId)) {
                NodePK nodeToSeek = new NodePK(nodeId, instanceId);
                while (classification == null && !nodeToSeek.isUndefined()) {
                    classification = this.classificationRepository.findPredefinedClassificationByNodeId(nodeToSeek.getId(), nodeToSeek.getInstanceId());
                    NodeDetail node = this.getNodeService().getDetail(nodeToSeek);
                    nodeToSeek = node.getFatherPK();
                }
                if (classification == null) {
                    classification = this.getPreDefinedClassification(instanceId);
                }
            } else {
                classification = this.getPreDefinedClassification(instanceId);
            }
            return classification;
        }
        catch (Exception ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    @Override
    public PdcClassification getPreDefinedClassification(String nodeId, String instanceId) {
        if (!StringUtil.isDefined((String)nodeId)) {
            return this.getPreDefinedClassification(instanceId);
        }
        NodePK nodeToSeek = new NodePK(nodeId, instanceId);
        PdcClassification classification = this.classificationRepository.findPredefinedClassificationByNodeId(nodeToSeek.getId(), nodeToSeek.getInstanceId());
        if (classification == null) {
            classification = PdcClassification.NONE_CLASSIFICATION;
        }
        return classification;
    }

    @Override
    public PdcClassification getPreDefinedClassification(String instanceId) {
        PdcClassification classification = this.classificationRepository.findPredefinedClassificationByComponentInstanceId(instanceId);
        if (classification == null) {
            classification = PdcClassification.NONE_CLASSIFICATION;
        }
        return classification;
    }

    @Override
    public PdcClassification savePreDefinedClassification(PdcClassification classification) {
        if (!classification.isPredefined()) {
            throw new IllegalArgumentException("The classification isn't a predefined one");
        }
        PdcClassification savedClassification = PdcClassification.NONE_CLASSIFICATION;
        if (classification.getId() != null && this.classificationRepository.contains((AbstractJpaEntity)classification) && classification.isEmpty()) {
            this.classificationRepository.delete((IdentifiableEntity[])new PdcClassification[]{classification});
        } else {
            for (PdcPosition aPosition : classification.getPositions()) {
                for (PdcAxisValue aValue : aPosition.getValues()) {
                    if (this.valueRepository.contains((AbstractJpaEntity)aValue)) continue;
                    this.valueRepository.save((IdentifiableEntity)aValue);
                }
            }
            savedClassification = (PdcClassification)this.classificationRepository.saveAndFlush(classification);
        }
        return savedClassification;
    }

    @Override
    public void deletePreDefinedClassification(String nodeId, String instanceId) {
        PdcClassification classification = !StringUtil.isDefined((String)nodeId) || "0".equals(nodeId) ? this.getPreDefinedClassification(instanceId) : this.getPreDefinedClassification(nodeId, instanceId);
        if (classification != PdcClassification.NONE_CLASSIFICATION) {
            this.classificationRepository.delete((IdentifiableEntity[])new PdcClassification[]{classification});
        }
    }

    @Override
    public void classifyContent(Contribution contribution, PdcClassification withClassification, boolean alertSubscribers) {
        List<ClassifyPosition> classifyPositions = withClassification.getClassifyPositions();
        try {
            ContributionIdentifier contributionId = contribution.getIdentifier();
            int silverObjectId = this.getOrCreateSilverpeasContentId(contribution);
            String componentInstanceId = contributionId.getComponentInstanceId();
            List<ClassifyPosition> existingPositions = this.getPdcManager().getPositions(silverObjectId, componentInstanceId);
            for (ClassifyPosition aClassifyPosition : classifyPositions) {
                int positionId = this.getPdcManager().addPosition(silverObjectId, aClassifyPosition, componentInstanceId, alertSubscribers);
                aClassifyPosition.setPositionId(positionId);
            }
            if (!existingPositions.isEmpty()) {
                for (ClassifyPosition anExistingPosition : existingPositions) {
                    if (this.isFound(anExistingPosition, classifyPositions)) continue;
                    this.getPdcManager().deletePosition(anExistingPosition.getPositionId(), componentInstanceId);
                }
            }
        }
        catch (PdcException ex) {
            throw new PdcRuntimeException((Throwable)((Object)ex));
        }
    }

    private int getOrCreateSilverpeasContentId(Contribution contribution) {
        if (contribution instanceof SilverpeasContent) {
            return Integer.parseInt(((SilverpeasContent)contribution).getSilverpeasContentId());
        }
        ContributionIdentifier contributionId = contribution.getIdentifier();
        Optional contentManager = SilverpeasContentManager.getByInstanceId((String)contributionId.getComponentInstanceId());
        if (contentManager.isPresent()) {
            return ((SilverpeasContentManager)contentManager.get()).getOrCreateSilverContentId(contribution);
        }
        throw new NotSupportedException(MessageFormat.format("contribution {0} must implements WithPdcClassification to be taken in charge", contributionId.asString()));
    }

    @Override
    public void axisValuesDeleted(List<PdcAxisValue> deletedValues) {
        List<PdcClassification> concernedClassifications = this.classificationRepository.findClassificationsByPdcAxisValues(deletedValues);
        for (PdcClassification aClassification : concernedClassifications) {
            aClassification.updateForPdcAxisValuesDeletion(deletedValues);
            this.savePreDefinedClassification(aClassification);
        }
        this.classificationRepository.flush();
        this.valueRepository.delete(deletedValues);
    }

    @Override
    public void axisDeleted(String axisId) {
        List<PdcAxisValue> valuesToDelete = this.valueRepository.findByAxisId(Long.valueOf(axisId));
        if (!valuesToDelete.isEmpty()) {
            this.axisValuesDeleted(valuesToDelete);
        }
    }

    protected NodeService getNodeService() {
        return this.nodeService;
    }

    protected PdcManager getPdcManager() {
        return PdcManager.get();
    }

    private boolean isFound(ClassifyPosition aPosition, List<ClassifyPosition> newPositions) {
        for (ClassifyPosition aNewPosition : newPositions) {
            if (aNewPosition.getPositionId() != aPosition.getPositionId()) continue;
            return true;
        }
        return false;
    }

    @Transactional
    public void delete(String componentInstanceId) {
        this.classificationRepository.deleteAllClassificationsByComponentInstanceId(componentInstanceId);
    }
}

