/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.contentcontainer.content.AbstractSilverpeasContentManager;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentVisibility;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.security.authorization.PublicationAccessControl;

@Service
public class KmeliaContentManager
extends AbstractSilverpeasContentManager
implements Serializable {
    private static final long serialVersionUID = 3525407153404515235L;
    private static final String CONTENT_ICON_FILE_NAME = "kmeliaSmall.gif";

    protected KmeliaContentManager() {
    }

    protected String getContentIconFileName(String componentInstanceId) {
        return CONTENT_ICON_FILE_NAME;
    }

    protected Optional<Contribution> getContribution(String resourceId, String componentInstanceId) {
        return Optional.ofNullable(this.getPublicationService().getDetail(new PublicationPK(resourceId, componentInstanceId)));
    }

    protected List<Contribution> getAccessibleContributions(List<ResourceReference> resourceReferences, String currentUserId) {
        List ids = resourceReferences.stream().map(r -> new PublicationPK(r.getLocalId(), r.getComponentInstanceId())).collect(Collectors.toList());
        List publications = this.getPublicationService().getPublications(ids);
        return PublicationAccessControl.get().filterAuthorizedByUser(currentUserId, (Collection)publications).collect(Collectors.toList());
    }

    public void deleteSilverContent(Connection con, PublicationPK pubPK) throws ContentManagerException {
        this.deleteSilverContent(con, pubPK.getId(), pubPK.getComponentName());
    }

    protected <T extends Contribution> SilverContentVisibility computeSilverContentVisibility(T contribution) {
        PublicationDetail pubDetail = (PublicationDetail)contribution;
        return new SilverContentVisibility(pubDetail.getBeginDate(), pubDetail.getEndDate(), this.isVisible(pubDetail));
    }

    private boolean isVisible(PublicationDetail pubDetail) {
        return "Valid".equals(pubDetail.getStatus());
    }

    private PublicationService getPublicationService() {
        return PublicationService.get();
    }
}

