(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    define(["converse"], factory);
  } else {
    factory(converse);
  }
}(this, function(converse) {
  let _converse, html, utils, spUtils, __, Model;

  converse.plugins.add("silverpeas-muc-destroy", {
    dependencies : ["silverpeas-commons"],

    initialize : function() {
      _converse = this._converse;

      utils = converse.env.utils;
      spUtils = converse.env.spUtils;
      html = converse.env.html;
      Model = converse.env.Model;
      __ = function(key) {
        switch (key) {
            // Handling here the msg override
          case 'Delete':
            return sp.i18n.get('chat.client.web.muc.destroy.text');
          case 'Delete this group chat':
            return sp.i18n.get('chat.client.web.muc.destroy.title');
          case 'Are you sure you want to delete @name@':
            return sp.i18n.get('chat.client.web.muc.destroy.confirm', '@name@');
          default:
            return _converse.__(key);
        }
      };

      _converse.api.listen.on('getHeadingButtons', function(heading_el, buttons) {
        sp.log.debug("getHeadingButtons", heading_el.model.get("jid"));
        if (heading_el.model.get("type") === "chatroom") {
          buttons.filter(function(button) {
            return button.name === 'destroy';
          }).forEach(function(button) {
            button.i18n_text = __('Delete');
            button.i18n_title = __('Delete this group chat');
            button.handler = performMucDestroy;
          });
        }
        return buttons;
      });

      function performMucDestroy(ev) {
        ev.preventDefault();
        const chatView = spUtils.getChatViewFromElement(ev.currentTarget);
        const chatModel = chatView.model;
        const confirmMsg = __('Are you sure you want to delete @name@')
            .replace(/@name@/g, chatModel.get('name') || chatModel.get('jid'));
        sp.popup.confirm(confirmMsg, function() {
          return chatModel.sendDestroyIQ().then(function() {
            return chatModel.close();
          });
        });
      }

      sp.log.debug("MUC invitation plugin is ready");
    }
  });
}));
