/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.webdav;

import java.io.IOException;
import javax.inject.Inject;
import javax.jcr.Repository;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.server.CredentialsProvider;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.simple.SimpleWebdavServlet;
import org.silverpeas.core.jcr.webdav.DavResourceLocatorFactory;
import org.silverpeas.core.jcr.webdav.HttpRequestFixer;
import org.silverpeas.core.jcr.webdav.WebDavCredentialsProvider;
import org.silverpeas.kernel.logging.SilverLogger;

public class JCRWebDavServlet
extends SimpleWebdavServlet {
    private static final long serialVersionUID = -6749255396944745234L;
    @Inject
    private Repository repository;
    @Inject
    private WebDavCredentialsProvider credentialsProvider;

    public void init() throws ServletException {
        super.init();
        this.setLocatorFactory((DavLocatorFactory)new DavResourceLocatorFactory(this.getPathPrefix()));
    }

    public Repository getRepository() {
        return this.repository;
    }

    protected CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            super.service((HttpServletRequest)new HttpRequestFixer(request), response);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)((Object)this)).error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }
}

