/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.security;

import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.login.LoginException;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.i18n.I18n;
import org.silverpeas.core.jcr.security.JCRUserCredentialsProvider;
import org.silverpeas.core.jcr.security.SilverpeasJCRLoginModule;
import org.silverpeas.core.security.authentication.Authentication;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.AuthenticationResponse;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;

public class SilverpeasSimpleJCRLoginModule
extends SilverpeasJCRLoginModule {
    static final Set<Class> SUPPORTED_CREDENTIALS = Set.of(SimpleCredentials.class);

    @Nonnull
    protected Set<Class> getSupportedCredentials() {
        return SUPPORTED_CREDENTIALS;
    }

    @Override
    protected User authenticateUser(Credentials credentials) throws LoginException {
        AuthenticationCredential cred;
        SimpleCredentials simpleCredentials = (SimpleCredentials)credentials;
        if (this.isJcrSystemCredentials(simpleCredentials)) {
            return User.getSystemUser();
        }
        Authentication auth = Authentication.get();
        AuthenticationResponse resp = auth.authenticate(cred = this.convert((SimpleCredentials)credentials));
        if (resp.getStatus().succeeded()) {
            try {
                String authToken = resp.getToken();
                return auth.getUserByAuthToken(authToken);
            }
            catch (AuthenticationException e) {
                throw new LoginException(e.getMessage());
            }
        }
        throw new LoginException(resp.getStatus().getMessage(I18n.get().getDefaultLanguage()));
    }

    private boolean isJcrSystemCredentials(SimpleCredentials credentials) {
        SimpleCredentials systemCredentials = (SimpleCredentials)JCRUserCredentialsProvider.getJcrSystemCredentials();
        return systemCredentials.getUserID().equals(credentials.getUserID()) && Arrays.equals(systemCredentials.getPassword(), credentials.getPassword());
    }

    @Nonnull
    private AuthenticationCredential convert(SimpleCredentials credentials) throws LoginException {
        AuthenticationCredential credential = JCRUserCredentialsProvider.getAuthCredentials(credentials);
        if (credential == null) {
            throw new LoginException("Invalid user ID in credentials!");
        }
        return credential;
    }
}

