/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.Throttler;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.cache.CacheInvalidationStats;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingDocumentStoreWrapper
implements DocumentStore {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingDocumentStoreWrapper.class);
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("ds.debug", "true"));
    private String logPrefix = "ds";
    final DocumentStore store;
    private boolean logThread;

    public LoggingDocumentStoreWrapper(DocumentStore store) {
        this.store = store;
    }

    public LoggingDocumentStoreWrapper(DocumentStore store, String prefix) {
        this.store = store;
        this.logPrefix = prefix;
    }

    public LoggingDocumentStoreWrapper withThreadNameLogging() {
        this.logThread = true;
        return this;
    }

    public LoggingDocumentStoreWrapper withPrefix(String prefix) {
        this.logPrefix = prefix;
        return this;
    }

    @Override
    public <T extends Document> T find(final Collection<T> collection, final String key) {
        try {
            this.logMethod("find", collection, key);
            return (T)((Document)this.logResult(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.find(collection, key);
                }
            }));
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> T find(final Collection<T> collection, final String key, final int maxCacheAge) {
        try {
            this.logMethod("find", collection, key, maxCacheAge);
            return (T)((Document)this.logResult(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.find(collection, key, maxCacheAge);
                }
            }));
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    @NotNull
    public <T extends Document> List<T> query(final Collection<T> collection, final String fromKey, final String toKey, final int limit) {
        try {
            this.logMethod("query", collection, fromKey, toKey, limit);
            return (List)this.logResult(new Callable<List<T>>(){

                @Override
                public List<T> call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.query(collection, fromKey, toKey, limit);
                }
            });
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    @NotNull
    public <T extends Document> List<T> query(final Collection<T> collection, final String fromKey, final String toKey, final String indexedProperty, final long startValue, final int limit) {
        try {
            this.logMethod("query", collection, fromKey, toKey, indexedProperty, startValue, limit);
            return (List)this.logResult(new Callable<List<T>>(){

                @Override
                public List<T> call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.query(collection, fromKey, toKey, indexedProperty, startValue, limit);
                }
            });
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    @NotNull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit, List<String> projection) throws DocumentStoreException {
        try {
            this.logMethod("query", collection, fromKey, toKey, indexedProperty, startValue, limit, projection.toString());
            return this.logResult(() -> this.store.query(collection, fromKey, toKey, indexedProperty, startValue, limit, projection));
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> void remove(Collection<T> collection, String key) {
        try {
            this.logMethod("remove", collection, key);
            this.store.remove(collection, key);
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> void remove(Collection<T> collection, List<String> keys) {
        try {
            this.logMethod("remove", collection, keys);
            this.store.remove(collection, keys);
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> int remove(final Collection<T> collection, final Map<String, Long> toRemove) {
        try {
            this.logMethod("remove", collection, toRemove);
            return this.logResult(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.remove(collection, toRemove);
                }
            });
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> int remove(final Collection<T> collection, final String indexedProperty, final long startValue, final long endValue) throws DocumentStoreException {
        try {
            this.logMethod("remove", collection, indexedProperty, startValue, endValue);
            return this.logResult(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.remove(collection, indexedProperty, startValue, endValue);
                }
            });
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> boolean create(final Collection<T> collection, final List<UpdateOp> updateOps) {
        try {
            this.logMethod("create", collection, updateOps);
            return this.logResult(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.create(collection, updateOps);
                }
            });
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> T createOrUpdate(final Collection<T> collection, final UpdateOp update) {
        try {
            this.logMethod("createOrUpdate", collection, update);
            return (T)((Document)this.logResult(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.createOrUpdate(collection, update);
                }
            }));
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> List<T> createOrUpdate(final Collection<T> collection, final List<UpdateOp> updateOps) {
        try {
            this.logMethod("createOrUpdate", collection, updateOps);
            return (List)this.logResult(new Callable<List<T>>(){

                @Override
                public List<T> call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.createOrUpdate(collection, updateOps);
                }
            });
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> T findAndUpdate(final Collection<T> collection, final UpdateOp update) {
        try {
            this.logMethod("findAndUpdate", collection, update);
            return (T)((Document)this.logResult(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.findAndUpdate(collection, update);
                }
            }));
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> List<T> findAndUpdate(@NotNull Collection<T> collection, @NotNull List<UpdateOp> updateOps) {
        try {
            this.logMethod("findAndUpdate", collection, updateOps);
            return this.logResult(() -> this.store.findAndUpdate(collection, updateOps));
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public CacheInvalidationStats invalidateCache() {
        try {
            this.logMethod("invalidateCache", new Object[0]);
            return this.store.invalidateCache();
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public CacheInvalidationStats invalidateCache(Iterable<String> keys) {
        try {
            this.logMethod("invalidateCache", keys);
            return this.store.invalidateCache(keys);
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> void invalidateCache(Collection<T> collection, String key) {
        try {
            this.logMethod("invalidateCache", collection, key);
            this.store.invalidateCache(collection, key);
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public void dispose() {
        try {
            this.logMethod("dispose", new Object[0]);
            this.store.dispose();
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> T getIfCached(final Collection<T> collection, final String key) {
        try {
            this.logMethod("getIfCached", collection, key);
            return (T)((Document)this.logResult(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.getIfCached(collection, key);
                }
            }));
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public void setReadWriteMode(String readWriteMode) {
        try {
            this.logMethod("setReadWriteMode", readWriteMode);
            this.store.setReadWriteMode(readWriteMode);
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public Iterable<CacheStats> getCacheStats() {
        try {
            this.logMethod("getCacheStats", new Object[0]);
            return this.logResult(new Callable<Iterable<CacheStats>>(){

                @Override
                public Iterable<CacheStats> call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.getCacheStats();
                }
            });
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.store.getMetadata();
    }

    @Override
    @NotNull
    public Map<String, String> getStats() {
        Map<String, String> result = this.store.getStats();
        this.logMethod("getStats", result);
        return result;
    }

    @Override
    public long determineServerTimeDifferenceMillis() {
        this.logMethod("determineServerTimeDifferenceMillis", "start");
        long result = this.store.determineServerTimeDifferenceMillis();
        this.logMethod("determineServerTimeDifferenceMillis", "end", result);
        return result;
    }

    @Override
    public int getNodeNameLimit() {
        this.logMethod("getNodeNameLimit", "start");
        int result = this.store.getNodeNameLimit();
        this.logMethod("getNodeNameLimit", "end", result);
        return result;
    }

    @Override
    public Throttler throttler() {
        this.logMethod("throttler", "start");
        Throttler result = this.store.throttler();
        this.logMethod("throttler", "end", result);
        return result;
    }

    private void logMethod(String methodName, Object ... args) {
        StringBuilder buff = new StringBuilder(this.logPrefix);
        buff.append('.').append(methodName).append('(');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(LoggingDocumentStoreWrapper.quote(args[i]));
        }
        buff.append(");");
        this.log(buff.toString());
    }

    public static String quote(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return JsopBuilder.encode((String)((String)o));
        }
        return o.toString();
    }

    private RuntimeException convert(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        this.log("// unexpected exception type: " + e.getClass().getName());
        return new DocumentStoreException("Unexpected exception: " + e.toString(), e);
    }

    private void logException(Exception e) {
        this.log("// exception: " + e.toString());
    }

    private <T> T logResult(Callable<T> callable) throws Exception {
        long time = System.nanoTime();
        T result = callable.call();
        time = System.nanoTime() - time;
        this.log("// " + time / 1000L + " us\t" + LoggingDocumentStoreWrapper.quote(result));
        return result;
    }

    private void log(String message) {
        String out;
        String string = out = this.logThread ? Thread.currentThread() + " " + message : message;
        if (DEBUG) {
            System.out.println(out);
        }
        LOG.info(out);
    }
}

