/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Map;
import java.util.Objects;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResetDiff
implements NodeStateDiff {
    private final ResetDiff parent;
    private final Revision revision;
    private final Path path;
    private final Map<Path, UpdateOp> operations;
    private UpdateOp update;

    ResetDiff(@NotNull Revision revision, @NotNull Map<Path, UpdateOp> operations) {
        this(null, revision, Path.ROOT, operations);
    }

    private ResetDiff(@Nullable ResetDiff parent, @NotNull Revision revision, @NotNull Path path, @NotNull Map<Path, UpdateOp> operations) {
        this.parent = parent;
        this.revision = Objects.requireNonNull(revision);
        this.path = Objects.requireNonNull(path);
        this.operations = Objects.requireNonNull(operations);
    }

    public boolean propertyAdded(PropertyState after) {
        this.getUpdateOp().removeMapEntry(after.getName(), this.revision);
        return true;
    }

    public boolean propertyChanged(PropertyState before, PropertyState after) {
        this.getUpdateOp().removeMapEntry(after.getName(), this.revision);
        return true;
    }

    public boolean propertyDeleted(PropertyState before) {
        this.getUpdateOp().removeMapEntry(before.getName(), this.revision);
        return true;
    }

    public boolean childNodeAdded(String name, NodeState after) {
        NodeDocument.removeCommitRoot(this.getUpdateOp(), this.revision);
        Path p = new Path(this.path, name);
        ResetDiff diff = new ResetDiff(this, this.revision, p, this.operations);
        UpdateOp op = diff.getUpdateOp();
        NodeDocument.removeDeleted(op, this.revision);
        NodeDocument.setDeletedOnce(op);
        if (this.parent != null) {
            this.parent.getUpdateOp();
        }
        return after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, (NodeStateDiff)diff);
    }

    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        Path p = new Path(this.path, name);
        return after.compareAgainstBaseState(before, (NodeStateDiff)new ResetDiff(this, this.revision, p, this.operations));
    }

    public boolean childNodeDeleted(String name, NodeState before) {
        Path p = new Path(this.path, name);
        ResetDiff diff = new ResetDiff(this, this.revision, p, this.operations);
        NodeDocument.removeDeleted(diff.getUpdateOp(), this.revision);
        return EmptyNodeState.MISSING_NODE.compareAgainstBaseState(before, (NodeStateDiff)diff);
    }

    Map<Path, UpdateOp> getOperations() {
        return this.operations;
    }

    private UpdateOp getUpdateOp() {
        if (this.update == null) {
            this.update = this.operations.get(this.path);
            if (this.update == null) {
                String id = Utils.getIdFromPath(this.path);
                this.update = new UpdateOp(id, false);
                this.operations.put(this.path, this.update);
            }
            NodeDocument.removeRevision(this.update, this.revision);
            NodeDocument.removeCommitRoot(this.update, this.revision);
            NodeDocument.removeBranchCommit(this.update, this.revision);
        }
        return this.update;
    }
}

