/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.sharing.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.persistence.OrderBy;
import org.silverpeas.core.persistence.datasource.model.identifier.UuidIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.sharing.security.ShareableAccessControl;
import org.silverpeas.core.sharing.security.ShareableResource;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.util.StringUtil;

@Entity
@Table(name="sb_filesharing_ticket")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="shared_object_type")
@AttributeOverride(name="id", column=@Column(name="keyfile", columnDefinition="varchar(40)", length=40))
@NamedQuery(name="Ticket.findAllTicketForSharedObjectId", query="SELECT t FROM Ticket t WHERE t.sharedObjectId = :sharedObjectId AND t.sharedObjectType = :ticketType")
public abstract class Ticket
extends BasicJpaEntity<Ticket, UuidIdentifier>
implements Serializable {
    private static final long serialVersionUID = -612174156104966079L;
    public static final String FILE_TYPE = "Attachment";
    public static final String VERSION_TYPE = "Versionned";
    public static final String NODE_TYPE = "Node";
    public static final String PUBLICATION_TYPE = "Publication";
    @Column(name="shared_object_type", nullable=false, insertable=false, updatable=false)
    protected String sharedObjectType;
    @Column(name="shared_object")
    protected long sharedObjectId;
    @Column(name="componentid")
    protected String componentId;
    @Column(name="creatorid")
    protected String creatorId;
    @Column(name="creationdate", nullable=false)
    protected Long creationDate;
    @Column(name="updateid")
    protected String updaterId;
    @Column(name="updatedate")
    protected Long updateDate = null;
    @Column(name="enddate")
    protected Long endDate = null;
    @Column(name="nbaccessmax")
    protected int nbAccessMax;
    @Column(name="nbaccess")
    protected int nbAccess;

    protected Ticket() {
    }

    protected Ticket(int sharedObjectId, String componentId, UserDetail creator, Date creationDate, Date endDate, int nbAccessMax) {
        this(sharedObjectId, componentId, creator.getId(), creationDate, endDate, nbAccessMax);
    }

    protected Ticket(int sharedObjectId, String componentId, String creatorId, Date creationDate, Date endDate, int nbAccessMax) {
        this.sharedObjectId = sharedObjectId;
        this.componentId = componentId;
        this.creatorId = creatorId;
        this.creationDate = creationDate.getTime();
        if (endDate != null) {
            this.endDate = endDate.getTime();
        }
        this.nbAccessMax = nbAccessMax;
    }

    public long getSharedObjectId() {
        return this.sharedObjectId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreator(UserDetail creator) {
        this.creatorId = creator.getId();
    }

    public Date getCreationDate() {
        return new Date(this.creationDate);
    }

    public void setLastModifier(UserDetail modifier) {
        this.updaterId = modifier.getId();
    }

    public String getLastModifier() {
        return this.updaterId;
    }

    public Date getUpdateDate() {
        if (this.updateDate != null) {
            return new Date(this.updateDate);
        }
        return null;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate != null ? Long.valueOf(updateDate.getTime()) : null;
    }

    public Date getEndDate() {
        Date date = null;
        if (this.endDate != null) {
            date = new Date(this.endDate);
        }
        return date;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate != null ? Long.valueOf(endDate.getTime()) : null;
    }

    public int getNbAccessMax() {
        return this.nbAccessMax;
    }

    public void setNbAccessMax(int nbAccessMax) {
        this.nbAccessMax = nbAccessMax;
    }

    public int getNbAccess() {
        return this.nbAccess;
    }

    public void setNbAccess(int nbAccess) {
        this.nbAccess = nbAccess;
    }

    public String getToken() {
        return this.getId();
    }

    public void setToken(String uuid) {
        this.setId(uuid);
    }

    public String getUrl(HttpServletRequest request) {
        return URLUtil.getFullApplicationURL((HttpServletRequest)request) + this.getRelativeUrl();
    }

    private String getRelativeUrl() {
        return "/Ticket?Key=" + this.getToken();
    }

    public boolean isValid() {
        if (StringUtil.isDefined((String)this.getToken())) {
            boolean isValid = true;
            if (this.getEndDate() != null) {
                isValid = this.getEndDate().after(new Date());
            }
            if (this.getNbAccessMax() > 0) {
                isValid &= this.getNbAccess() < this.getNbAccessMax();
            }
            return isValid;
        }
        return false;
    }

    public boolean isModified() {
        return this.updateDate != null && StringUtil.isDefined((String)this.updaterId);
    }

    public boolean isUnlimited() {
        return this.nbAccessMax <= 0 && this.endDate == null;
    }

    public void setAsUnlimited() {
        this.endDate = null;
        this.nbAccessMax = 0;
    }

    public String getSharedObjectType() {
        return this.sharedObjectType;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.getId() != null ? this.getId().hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ticket other = (Ticket)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    public String toString() {
        return "Ticket{sharedObjectType=" + this.sharedObjectType + ", sharedObjectId=" + this.sharedObjectId + ", componentId=" + this.componentId + ", creatorId=" + this.creatorId + ", creationDate=" + this.creationDate + ", updaterId=" + this.updaterId + ", updateDate=" + this.updateDate + ", endDate=" + this.endDate + ", nbAccessMax=" + this.nbAccessMax + ", nbAccess=" + this.nbAccess + ", token=" + this.getId() + "}";
    }

    public void addDownload() {
        ++this.nbAccess;
    }

    public abstract ShareableAccessControl getAccessControl();

    public abstract <R> ShareableResource<R> getResource();

    public static enum QUERY_ORDER_BY {
        CREATION_DATE_ASC(OrderBy.asc((String)"creationDate")),
        CREATION_DATE_DESC(OrderBy.desc((String)"creationDate")),
        END_DATE_ASC(OrderBy.asc((String)"enddate")),
        END_DATE_DESC(OrderBy.desc((String)"enddate")),
        NB_ACCESS_DATE_ASC(OrderBy.asc((String)"nbaccess")),
        NB_ACCESS_DATE_DESC(OrderBy.desc((String)"nbaccess"));

        private final OrderBy orderBy;

        private QUERY_ORDER_BY(OrderBy orderBy) {
            this.orderBy = orderBy;
        }

        public OrderBy getOrderBy() {
            return this.orderBy;
        }
    }
}

