/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.test;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.jcetaglib.lib.Signatures;
import net.sourceforge.jcetaglib.lib.X509Cert;
import net.sourceforge.jcetaglib.test.RunTest;

public class SignatureTest
extends TestCase {
    private StringBuffer sig = null;

    protected void setUp() throws IOException {
        FileOutputStream outStr = new FileOutputStream("C:/tmp/readable.txt");
        DataOutputStream dataStr = new DataOutputStream(outStr);
        dataStr.writeBytes("This is a readable string inside a file");
        dataStr.flush();
        dataStr.close();
        outStr.close();
    }

    public void testSignature() throws Exception {
        X509Certificate alicecert = X509Cert.getCertificateFromP12("C:/tmp/alice.p12", "alice", new StringBuffer("password"));
        PrivateKey aliceprivate = X509Cert.getPrivateFromP12("C:/tmp/alice.p12", "alice", new StringBuffer("password"));
        for (int i = 0; i < RunTest.sig.length; ++i) {
            for (int j = 0; j < RunTest.text.length; ++j) {
                this.sig = Signatures.generateSIG(RunTest.text[j], aliceprivate, RunTest.sig[i]);
                Assert.assertTrue((boolean)Signatures.verifySIG(RunTest.text[j], this.sig, alicecert.getPublicKey(), RunTest.sig[i]));
            }
        }
    }

    public void testFileSignature() throws Exception {
        X509Certificate alicecert = X509Cert.getCertificateFromP12("C:/tmp/alice.p12", "alice", new StringBuffer("password"));
        PrivateKey aliceprivate = X509Cert.getPrivateFromP12("C:/tmp/alice.p12", "alice", new StringBuffer("password"));
        for (int i = 0; i < RunTest.sig.length; ++i) {
            this.sig = Signatures.generateFileSIG("C:/tmp/readable.txt", aliceprivate, RunTest.sig[i]);
            Assert.assertTrue((boolean)Signatures.verifyFileSIG("C:/tmp/readable.txt", this.sig, alicecert.getPublicKey(), RunTest.sig[i]));
        }
    }
}

