/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.test;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.jcetaglib.lib.Hybrid;
import net.sourceforge.jcetaglib.lib.X509Cert;
import net.sourceforge.jcetaglib.test.RunTest;
import net.sourceforge.jcetaglib.tools.SignerCertificate;

public class HybridTest
extends TestCase {
    private StringBuffer ciphertext = null;
    private StringBuffer plaintext = null;

    protected void setUp() throws IOException {
        FileOutputStream outStr = new FileOutputStream("C:/tmp/readable.txt");
        DataOutputStream dataStr = new DataOutputStream(outStr);
        dataStr.writeBytes("This is a readable string inside a file");
        dataStr.flush();
        dataStr.close();
        outStr.close();
    }

    public void testEncryptWithHMAC() throws Exception {
        X509Certificate alicecert = X509Cert.getCertificateFromP12("C:/tmp/alice.p12", "alice", new StringBuffer("password"));
        PrivateKey aliceprivate = X509Cert.getPrivateFromP12("C:/tmp/alice.p12", "alice", new StringBuffer("password"));
        for (int i = 0; i < RunTest.text.length; ++i) {
            this.ciphertext = Hybrid.encryptWithHMAC(RunTest.text[i], alicecert.getPublicKey(), "AES", null, 128, "CBC", "PKCS7Padding");
            this.plaintext = Hybrid.decryptAndVerifyHMAC(this.ciphertext, aliceprivate, "AES", "CBC", "PKCS7Padding");
            Assert.assertEquals((String)RunTest.text[i].toString(), (String)this.plaintext.toString());
        }
    }

    public void testEncryptFileWithHMAC() throws Exception {
        int c;
        X509Certificate bobcert = X509Cert.getCertificateFromP12("C:/tmp/bob.p12", "bob", new StringBuffer("password"));
        PrivateKey bobprivate = X509Cert.getPrivateFromP12("C:/tmp/bob.p12", "bob", new StringBuffer("password"));
        Hybrid.encryptFileWithHMAC("C:/tmp/readable.txt", "C:/tmp/readable.txt.encrypted", bobcert.getPublicKey(), "AES", null, 128, "CBC", "PKCS7Padding");
        Hybrid.decryptFileAndVerifyHMAC("C:/tmp/readable.txt.encrypted", "C:/tmp/readable.txt.decrypted", bobprivate, "AES", "CBC", "PKCS7Padding");
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("C:/tmp/readable.txt.decrypted")));
        StringBuffer line = new StringBuffer();
        while ((c = reader.read()) != -1) {
            line.append((char)c);
        }
        reader.close();
        String t = line.toString();
        Assert.assertEquals((String)"This is a readable string inside a file", (String)t);
    }

    public void testEncryptAndSign() throws Exception {
        X509Certificate alicecert = X509Cert.getCertificateFromP12("C:/tmp/alice.p12", "alice", new StringBuffer("password"));
        PrivateKey aliceprivate = X509Cert.getPrivateFromP12("C:/tmp/alice.p12", "alice", new StringBuffer("password"));
        X509Certificate bobcert = X509Cert.getCertificateFromP12("C:/tmp/bob.p12", "bob", new StringBuffer("password"));
        PrivateKey bobprivate = X509Cert.getPrivateFromP12("C:/tmp/bob.p12", "bob", new StringBuffer("password"));
        for (int i = 0; i < RunTest.text.length; ++i) {
            this.ciphertext = Hybrid.encryptAndSign(RunTest.text[i], alicecert.getPublicKey(), bobprivate, bobcert, "MD5WithRSA", "AES", null, 128, "CBC", "PKCS7Padding");
            SignerCertificate s = new SignerCertificate();
            this.plaintext = Hybrid.decryptAndVerify(this.ciphertext, aliceprivate, s, "MD5WithRSA", "AES", "CBC", "PKCS7Padding");
            Assert.assertEquals((String)RunTest.text[i].toString(), (String)this.plaintext.toString());
            Assert.assertEquals((String)((Object)s.getCert().getSubjectDN()).toString(), (String)"EMAILADDRESS=bob@sourceforge.net, CN=Bob, OU=Sourceforge, O=NET, C=BE");
        }
    }

    public void testEncryptFileAndSign() throws Exception {
        int c;
        X509Certificate alicecert = X509Cert.getCertificateFromP12("C:/tmp/alice.p12", "alice", new StringBuffer("password"));
        PrivateKey aliceprivate = X509Cert.getPrivateFromP12("C:/tmp/alice.p12", "alice", new StringBuffer("password"));
        X509Certificate bobcert = X509Cert.getCertificateFromP12("C:/tmp/bob.p12", "bob", new StringBuffer("password"));
        PrivateKey bobprivate = X509Cert.getPrivateFromP12("C:/tmp/bob.p12", "bob", new StringBuffer("password"));
        Hybrid.encryptFileAndSign("C:/tmp/readable.txt", "C:/tmp/readable.txt.encrypted", alicecert.getPublicKey(), bobprivate, bobcert, "MD5WithRSA", "AES", null, 256, "CBC", "PKCS7Padding");
        SignerCertificate s = new SignerCertificate();
        Hybrid.decryptFileAndVerify("C:/tmp/readable.txt.encrypted", "C:/tmp/readable.txt.decrypted", aliceprivate, s, "MD5WithRSA", "AES", "CBC", "PKCS7Padding");
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("C:/tmp/readable.txt.decrypted")));
        StringBuffer line = new StringBuffer();
        while ((c = reader.read()) != -1) {
            line.append((char)c);
        }
        reader.close();
        String t = line.toString();
        Assert.assertEquals((String)"This is a readable string inside a file", (String)t);
        Assert.assertEquals((String)((Object)s.getCert().getSubjectDN()).toString(), (String)"EMAILADDRESS=bob@sourceforge.net, CN=Bob, OU=Sourceforge, O=NET, C=BE");
    }
}

