/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.lib;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.sourceforge.jcetaglib.lib.Clean;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DHKeyAgreement {
    private static final byte[] SKIP_1024_MODULUS_BYTES = new byte[]{-12, -120, -3, 88, 78, 73, -37, -51, 32, -76, -99, -28, -111, 7, 54, 107, 51, 108, 56, 13, 69, 29, 15, 124, -120, -77, 28, 124, 91, 45, -114, -10, -13, -55, 35, -64, 67, -16, -91, 91, 24, -115, -114, -69, 85, -116, -72, 93, 56, -45, 52, -3, 124, 23, 87, 67, -93, 29, 24, 108, -34, 51, 33, 44, -75, 42, -1, 60, -31, -79, 41, 64, 24, 17, -115, 124, -124, -89, 10, 114, -42, -122, -60, 3, 25, -56, 7, 41, 122, -54, -107, 12, -39, -106, -97, -85, -48, 10, 80, -101, 2, 70, -45, 8, 61, 102, -92, 93, 65, -97, -100, 124, -67, -119, 75, 34, 25, 38, -70, -85, -94, 94, -61, 85, -23, 47, 120, -57};
    private static final BigInteger MODULUS = new BigInteger(1, SKIP_1024_MODULUS_BYTES);
    private static final BigInteger BASE = BigInteger.valueOf(2L);
    private static final DHParameterSpec PARAMETER_SPEC = new DHParameterSpec(MODULUS, BASE);

    public static KeyPair generateDHKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator g = KeyPairGenerator.getInstance("DH", "BC");
        g.initialize(PARAMETER_SPEC);
        return g.generateKeyPair();
    }

    public static Key generateSessionKey(PublicKey pubkey, PrivateKey privkey, String algorithm, int length) throws NoSuchAlgorithmException, InvalidKeyException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyAgreement ka = KeyAgreement.getInstance("DH");
        ka.init(privkey);
        ka.doPhase(pubkey, true);
        byte[] sessionKeyBytes = ka.generateSecret();
        byte[] newBytes = new byte[length / 8];
        System.arraycopy(sessionKeyBytes, 0, newBytes, 0, length / 8);
        SecretKeySpec sessionKey = new SecretKeySpec(newBytes, algorithm);
        Clean.blank(sessionKeyBytes);
        Clean.blank(newBytes);
        return sessionKey;
    }

    public static byte[] publicKeyToBytes(PublicKey pub) {
        return pub.getEncoded();
    }

    public static PublicKey bytesToPublicKey(byte[] keyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory kf = KeyFactory.getInstance("DH");
        X509EncodedKeySpec x509Spec = new X509EncodedKeySpec(keyBytes);
        return kf.generatePublic(x509Spec);
    }
}

