/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.model;

import java.io.Serializable;
import java.util.List;
import org.silverpeas.components.kmelia.model.KmeliaPublication;
import org.silverpeas.components.kmelia.model.PubliAuthorComparator;
import org.silverpeas.components.kmelia.model.PubliCreationDateComparator;
import org.silverpeas.components.kmelia.model.PubliDescriptionComparator;
import org.silverpeas.components.kmelia.model.PubliImportanceComparator;
import org.silverpeas.components.kmelia.model.PubliRankComparator;
import org.silverpeas.components.kmelia.model.PubliTitleComparator;
import org.silverpeas.components.kmelia.model.PubliUpdateDateComparator;

public class KmeliaPublicationSort
implements Serializable {
    private static final long serialVersionUID = 123918700477888284L;
    public static final int SORT_CREATOR_ASC = 0;
    public static final int SORT_UPDATE_ASC = 1;
    public static final int SORT_UPDATE_DESC = 2;
    public static final int SORT_IMPORTANCE_ASC = 3;
    public static final int SORT_TITLE_ASC = 4;
    public static final int SORT_CREATION_ASC = 5;
    public static final int SORT_CREATION_DESC = 6;
    public static final int SORT_DESCRIPTION_ASC = 7;
    public static final int SORT_MANUAL = 99;
    private int currentSort;
    private boolean explicitSort = false;
    private boolean manualSortEnable = false;

    public KmeliaPublicationSort(int initialSort) {
        this.currentSort = initialSort;
    }

    public int getCurrentSort() {
        return this.currentSort;
    }

    public void setCurrentSort(int currentSort) {
        this.currentSort = currentSort;
    }

    public boolean isExplicitSort() {
        return this.explicitSort;
    }

    public void setExplicitSort(boolean explicitSort) {
        this.explicitSort = explicitSort;
    }

    public boolean isManualSortEnable() {
        return this.manualSortEnable;
    }

    public void setManualSortEnable(boolean manualSortEnable) {
        this.manualSortEnable = manualSortEnable;
    }

    public SortConsumer<List<KmeliaPublication>> withContentLanguage(String language) {
        return p -> {
            if (p != null) {
                switch (this.currentSort) {
                    case 0: {
                        p.sort(new PubliAuthorComparator(true));
                        break;
                    }
                    case 1: {
                        p.sort(new PubliUpdateDateComparator(true));
                        break;
                    }
                    case 2: {
                        p.sort(new PubliUpdateDateComparator(false));
                        break;
                    }
                    case 3: {
                        p.sort(new PubliImportanceComparator(false));
                        break;
                    }
                    case 4: {
                        p.sort(new PubliTitleComparator(true, language));
                        break;
                    }
                    case 5: {
                        p.sort(new PubliCreationDateComparator(true));
                        break;
                    }
                    case 6: {
                        p.sort(new PubliCreationDateComparator(false));
                        break;
                    }
                    case 7: {
                        p.sort(new PubliDescriptionComparator(true, language));
                        break;
                    }
                    default: {
                        p.sort(new PubliRankComparator(true));
                    }
                }
            }
        };
    }

    @FunctionalInterface
    public static interface SortConsumer<T> {
        public void sort(T var1);
    }
}

