/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.connect;

import org.springframework.social.ApiException;
import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.ConnectionValues;
import org.springframework.social.connect.UserProfile;
import org.springframework.social.connect.UserProfileBuilder;
import org.springframework.social.facebook.api.Facebook;
import org.springframework.social.facebook.api.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookAdapter
implements ApiAdapter<Facebook> {
    public boolean test(Facebook facebook) {
        try {
            facebook.userOperations().getUserProfile();
            return true;
        }
        catch (ApiException e) {
            return false;
        }
    }

    public void setConnectionValues(Facebook facebook, ConnectionValues values) {
        User profile = facebook.fetchObject("me", User.class, "id", "name", "link");
        values.setProviderUserId(profile.getId());
        values.setDisplayName(profile.getName());
        values.setProfileUrl(profile.getLink());
        values.setImageUrl(facebook.getBaseGraphApiUrl() + profile.getId() + "/picture");
    }

    public UserProfile fetchUserProfile(Facebook facebook) {
        User profile = facebook.userOperations().getUserProfile();
        return new UserProfileBuilder().setName(profile.getName()).setFirstName(profile.getFirstName()).setLastName(profile.getLastName()).setEmail(profile.getEmail()).build();
    }

    public void updateStatus(Facebook facebook, String message) {
        facebook.feedOperations().updateStatus(message);
    }
}

