/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.rfc2251;

import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Decoder;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.rfc2251.RfcLDAPOID;
import java.io.IOException;
import java.io.InputStream;

public class RfcControl
extends ASN1Sequence {
    public RfcControl(RfcLDAPOID controlType) {
        this(controlType, new ASN1Boolean(false), null);
    }

    public RfcControl(RfcLDAPOID controlType, ASN1Boolean criticality) {
        this(controlType, criticality, null);
    }

    public RfcControl(RfcLDAPOID controlType, ASN1Boolean criticality, ASN1OctetString controlValue) {
        super(3);
        this.add(controlType);
        if (criticality.booleanValue()) {
            this.add(criticality);
        }
        if (controlValue != null) {
            this.add(controlValue);
        }
    }

    public RfcControl(ASN1Decoder dec, InputStream in, int len) throws IOException {
        super(dec, in, len);
    }

    public RfcControl(ASN1Sequence seqObj) throws IOException {
        super(3);
        int len = seqObj.size();
        for (int i = 0; i < len; ++i) {
            this.add(seqObj.get(i));
        }
    }

    public final ASN1OctetString getControlType() {
        return (ASN1OctetString)this.get(0);
    }

    public final ASN1Boolean getCriticality() {
        ASN1Object obj;
        if (this.size() > 1 && (obj = this.get(1)) instanceof ASN1Boolean) {
            return (ASN1Boolean)obj;
        }
        return new ASN1Boolean(false);
    }

    public final ASN1OctetString getControlValue() {
        ASN1Object obj;
        if (this.size() > 2) {
            return (ASN1OctetString)this.get(2);
        }
        if (this.size() > 1 && (obj = this.get(1)) instanceof ASN1OctetString) {
            return (ASN1OctetString)obj;
        }
        return null;
    }

    public final void setControlValue(ASN1OctetString controlValue) {
        if (controlValue == null) {
            return;
        }
        if (this.size() == 3) {
            this.set(2, controlValue);
            return;
        }
        if (this.size() == 2) {
            ASN1Object obj = this.get(1);
            if (obj instanceof ASN1OctetString) {
                this.set(1, controlValue);
                return;
            }
            this.add(controlValue);
            return;
        }
        if (this.size() == 1) {
            this.add(controlValue);
            return;
        }
    }
}

