/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1SequenceOf;
import com.novell.ldap.asn1.LBEREncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class SetReplicationFilterRequest
extends LDAPExtendedOperation {
    public SetReplicationFilterRequest(String serverDN, String[][] replicationFilter) throws LDAPException {
        super("2.16.840.1.113719.1.27.100.35", null);
        try {
            if (serverDN == null) {
                throw new IllegalArgumentException("PARAM_ERROR");
            }
            ByteArrayOutputStream encodedData = new ByteArrayOutputStream();
            LBEREncoder encoder = new LBEREncoder();
            ASN1OctetString asn1_serverDN = new ASN1OctetString(serverDN);
            asn1_serverDN.encode(encoder, encodedData);
            ASN1SequenceOf asn1_replicationFilter = new ASN1SequenceOf();
            if (replicationFilter == null) {
                asn1_replicationFilter.encode(encoder, encodedData);
                this.setValue(encodedData.toByteArray());
                return;
            }
            for (int i = 0; i < replicationFilter.length && replicationFilter[i] != null; ++i) {
                ASN1Sequence buginASN1Representation = new ASN1Sequence();
                buginASN1Representation.add(new ASN1OctetString(replicationFilter[i][0]));
                ASN1SequenceOf asn1_attributeList = new ASN1SequenceOf();
                for (int j = 1; j < replicationFilter[i].length && replicationFilter[i][j] != null; ++j) {
                    asn1_attributeList.add(new ASN1OctetString(replicationFilter[i][j]));
                }
                buginASN1Representation.add(asn1_attributeList);
                asn1_replicationFilter.add(buginASN1Representation);
            }
            asn1_replicationFilter.encode(encoder, encodedData);
            this.setValue(encodedData.toByteArray());
        }
        catch (IOException ioe) {
            throw new LDAPException("ENCODING_ERROR", 83, null);
        }
    }
}

