/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Set;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.IOException;

public class GetEffectivePrivilegesListResponse
extends LDAPExtendedResponse {
    private int[] privileges = new int[]{0};
    private int no_privileges;

    public GetEffectivePrivilegesListResponse(RfcLDAPMessage rfcMessage) throws IOException {
        super(rfcMessage);
        if (this.getResultCode() == 0) {
            byte[] returnedValue = this.getValue();
            if (returnedValue == null) {
                throw new IOException("No returned value");
            }
            LBERDecoder decoder = new LBERDecoder();
            if (decoder == null) {
                throw new IOException("Decoding error");
            }
            ASN1Sequence asn1_seq1 = (ASN1Sequence)decoder.decode(returnedValue);
            if (asn1_seq1 == null) {
                throw new IOException("Decoding error");
            }
            ASN1Sequence asn1_seq2 = (ASN1Sequence)asn1_seq1.get(0);
            this.no_privileges = ((ASN1Integer)asn1_seq2.get(0)).intValue();
            ASN1Set set_privileg_response = null;
            Object asn1_privileges = null;
            set_privileg_response = (ASN1Set)asn1_seq1.get(1);
            ASN1Sequence seq2 = null;
            this.privileges = new int[this.no_privileges];
            for (int index = 0; index < this.no_privileges; ++index) {
                seq2 = (ASN1Sequence)set_privileg_response.get(index);
                this.privileges[index] = ((ASN1Integer)seq2.get(0)).intValue();
            }
        }
    }

    public int[] getPrivileges() {
        return this.privileges;
    }
}

