/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class BinderyObjectEventData
implements EventResponseData {
    private final String entryDN;
    private final int type;
    private final int emuObjFlags;
    private final int security;
    private final String name;

    public BinderyObjectEventData(ASN1Object message) throws IOException {
        byte[] data = ((ASN1OctetString)message).byteValue();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        LBERDecoder decode = new LBERDecoder();
        int[] length = new int[1];
        this.entryDN = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.type = ((ASN1Integer)decode.decode(in, length)).intValue();
        this.emuObjFlags = ((ASN1Integer)decode.decode(in, length)).intValue();
        this.security = ((ASN1Integer)decode.decode(in, length)).intValue();
        this.name = ((ASN1OctetString)decode.decode(in, length)).stringValue();
    }

    public int getEmuObjFlags() {
        return this.emuObjFlags;
    }

    public String getEntryDN() {
        return this.entryDN;
    }

    public String getName() {
        return this.name;
    }

    public int getSecurity() {
        return this.security;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[BinderyObjectEvent[EntryDn=" + this.getEntryDN() + "]");
        buf.append("[Type=" + this.getType() + "]");
        buf.append("[EnumOldFlags=" + this.getEmuObjFlags() + "]");
        buf.append("[Secuirty=" + this.getSecurity() + "]");
        buf.append("[Name=" + this.getName() + "]]");
        return buf.toString();
    }
}

