/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.rfc2251.RfcAssertionValue;
import com.novell.ldap.rfc2251.RfcAttributeDescription;
import com.novell.ldap.rfc2251.RfcAttributeValueAssertion;
import com.novell.ldap.rfc2251.RfcCompareRequest;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.IOException;

public class LDAPCompareRequest
extends LDAPMessage {
    public LDAPCompareRequest() {
        super(14);
    }

    public LDAPCompareRequest(String dn, String name, byte[] value, LDAPControl[] cont) throws LDAPException {
        super(14, new RfcCompareRequest(new RfcLDAPDN(dn), new RfcAttributeValueAssertion(new RfcAttributeDescription(name), new RfcAssertionValue(value))), cont);
    }

    public String getAttributeDescription() {
        RfcCompareRequest req = (RfcCompareRequest)this.getASN1Object().getRequest();
        return req.getAttributeValueAssertion().getAttributeDescription();
    }

    public byte[] getAssertionValue() {
        RfcCompareRequest req = (RfcCompareRequest)this.getASN1Object().getRequest();
        return req.getAttributeValueAssertion().getAssertionValue();
    }

    public String getDN() {
        return this.getASN1Object().getRequestDN();
    }

    protected void setDeserializedValues(LDAPMessage readObject, RfcControls asn1Ctrls) throws IOException, ClassNotFoundException {
        if (!(readObject instanceof LDAPCompareRequest)) {
            throw new ClassNotFoundException("Error occured while deserializing LDAPCompareRequest object");
        }
        LDAPCompareRequest tmp = (LDAPCompareRequest)readObject;
        String dn = tmp.getDN();
        String name = tmp.getAttributeDescription();
        byte[] value = tmp.getAssertionValue();
        tmp = null;
        RfcCompareRequest operation = new RfcCompareRequest(new RfcLDAPDN(dn), new RfcAttributeValueAssertion(new RfcAttributeDescription(name), new RfcAssertionValue(value)));
        this.message = new RfcLDAPMessage(operation, asn1Ctrls);
        readObject = null;
    }
}

