/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.configuration;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import org.jasig.cas.client.configuration.BaseConfigurationStrategy;
import org.jasig.cas.client.configuration.ConfigurationKey;
import org.jasig.cas.client.util.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiConfigurationStrategyImpl
extends BaseConfigurationStrategy {
    private static final String ENVIRONMENT_PREFIX = "java:comp/env/cas/";
    private final String environmentPrefix;
    private InitialContext context;
    private String simpleFilterName;

    public JndiConfigurationStrategyImpl() {
        this(ENVIRONMENT_PREFIX);
    }

    public JndiConfigurationStrategyImpl(String environmentPrefix) {
        this.environmentPrefix = environmentPrefix;
    }

    @Override
    protected final String get(ConfigurationKey configurationKey) {
        if (this.context == null) {
            return null;
        }
        String propertyName = configurationKey.getName();
        String filterValue = this.loadFromContext(this.context, this.environmentPrefix + this.simpleFilterName + "/" + propertyName);
        if (CommonUtils.isNotBlank(filterValue)) {
            this.logger.info("Property [{}] loaded from JNDI Filter Specific Property with value [{}]", (Object)propertyName, (Object)filterValue);
            return filterValue;
        }
        String rootValue = this.loadFromContext(this.context, this.environmentPrefix + propertyName);
        if (CommonUtils.isNotBlank(rootValue)) {
            this.logger.info("Property [{}] loaded from JNDI with value [{}]", (Object)propertyName, (Object)rootValue);
            return rootValue;
        }
        return null;
    }

    private String loadFromContext(InitialContext context, String path) {
        try {
            return (String)context.lookup(path);
        }
        catch (NamingException e) {
            return null;
        }
    }

    @Override
    public final void init(FilterConfig filterConfig, Class<? extends Filter> clazz) {
        this.simpleFilterName = clazz.getSimpleName();
        try {
            this.context = new InitialContext();
        }
        catch (NamingException e) {
            this.logger.error("Unable to create InitialContext. No properties can be loaded via JNDI.", (Throwable)e);
        }
    }
}

