/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.thesaurus.service;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.model.Value;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.core.pdc.thesaurus.model.Jargon;
import org.silverpeas.core.pdc.thesaurus.model.Synonym;
import org.silverpeas.core.pdc.thesaurus.model.ThesaurusException;
import org.silverpeas.core.pdc.thesaurus.service.ThesaurusService;

@Service
public class ThesaurusManager {
    @Inject
    private ThesaurusService thesaurus;

    protected ThesaurusManager() {
    }

    public Collection<String> getSynonyms(String mot, String idUser) throws ThesaurusException {
        ArrayList<String> finalList = new ArrayList<String>();
        Jargon jargon = this.getJargon(idUser);
        if (jargon != null) {
            long idVoca = jargon.getIdVoca();
            Collection<String> synonyms = this.getSynonymsTerm(idVoca, mot);
            ArrayList<String> interList = new ArrayList<String>(synonyms);
            Collection<String> otherSynonyms = this.getSynonyms(idVoca, mot);
            interList.addAll(otherSynonyms);
            for (String synonyme : interList) {
                if (this.isExist(synonyme, finalList) || mot.equalsIgnoreCase(synonyme)) continue;
                finalList.add(synonyme);
            }
        }
        return finalList;
    }

    private Collection<String> getSynonymsTerm(long idVoca, String term) throws ThesaurusException {
        ArrayList<String> theList = new ArrayList<String>();
        try {
            PdcManager pdc = PdcManager.get();
            List<Value> valueList = pdc.getAxisValuesByName(term);
            for (Value value : valueList) {
                long idTree = Long.parseLong(value.getTreeId());
                long idTerm = Long.parseLong(value.getPK().getId());
                Collection<Synonym> synonymes = this.thesaurus.getSynonyms(idVoca, idTree, idTerm);
                for (Synonym synonyme : synonymes) {
                    String nom = synonyme.getName();
                    theList.add(nom);
                }
            }
        }
        catch (PdcException e) {
            throw new ThesaurusException((Throwable)((Object)e));
        }
        return theList;
    }

    private Collection<String> getSynonyms(long idVoca, String synonym) throws ThesaurusException {
        ArrayList<String> theList = new ArrayList<String>();
        try {
            Collection<Synonym> synonymsList = this.thesaurus.getSynonyms(idVoca, synonym);
            for (Synonym aSynonym : synonymsList) {
                long idTree = aSynonym.getIdTree();
                long idTerm = aSynonym.getIdTerm();
                Collection<Synonym> synonyms = this.thesaurus.getSynonyms(idVoca, idTree, idTerm);
                for (Synonym synonymTerm : synonyms) {
                    String name = synonymTerm.getName();
                    theList.add(name);
                    PdcManager pdc = PdcManager.get();
                    Value value = pdc.getAxisValue(Long.toString(idTerm), Long.toString(idTree));
                    String nameTerm = value.getName();
                    theList.add(nameTerm);
                }
            }
        }
        catch (PdcException e) {
            throw new ThesaurusException((Throwable)((Object)e));
        }
        return theList;
    }

    private boolean isExist(String nom, Collection<String> tab) {
        for (String mot : tab) {
            if (!nom.equalsIgnoreCase(mot)) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getSynonyms(long idTree, long idTerm, String idUser) throws ThesaurusException {
        ArrayList<String> theList = new ArrayList<String>();
        Jargon jargon = this.getJargon(idUser);
        if (jargon != null) {
            long idVoca = jargon.getIdVoca();
            theList.addAll(this.getSynonyms(idTree, idTerm, idVoca));
        }
        return theList;
    }

    public Collection<String> getSynonyms(long idTree, long idTerm, long idVoca) throws ThesaurusException {
        ArrayList<String> theList = new ArrayList<String>();
        Collection<Synonym> synonyms = this.thesaurus.getSynonyms(idVoca, idTree, idTerm);
        for (Synonym synonym : synonyms) {
            theList.add(synonym.getName());
        }
        return theList;
    }

    public Collection<Synonym> getSynonymsByTree(long idTree, long idVoca) throws ThesaurusException {
        return this.thesaurus.getSynonymsByTree(idVoca, idTree);
    }

    public Collection<String> getSynonymsAxis(String axisId, String idUser) throws ThesaurusException {
        ArrayList<String> theList = new ArrayList<String>();
        try {
            Jargon jargon = this.getJargon(idUser);
            if (jargon != null) {
                long idVoca = jargon.getIdVoca();
                PdcManager pdc = PdcManager.get();
                Value value = pdc.getRoot(axisId);
                long idTree = Long.parseLong(value.getTreeId());
                long idTerm = Long.parseLong(value.getPK().getId());
                Collection<Synonym> synonyms = this.thesaurus.getSynonyms(idVoca, idTree, idTerm);
                for (Synonym synonym : synonyms) {
                    theList.add(synonym.getName());
                }
            }
        }
        catch (PdcException e) {
            throw new ThesaurusException((Throwable)((Object)e));
        }
        return theList;
    }

    public Jargon getJargon(String idUser) throws ThesaurusException {
        return this.thesaurus.getJargon(idUser);
    }

    public void deleteSynonymsAxis(Connection con, long idTree) throws ThesaurusException {
        this.thesaurus.deleteSynonymsAxis(con, idTree);
    }

    public void deleteSynonymsTerms(Connection con, long idTree, List<String> idTerms) throws ThesaurusException {
        this.thesaurus.deleteSynonymsTerms(con, idTree, idTerms);
    }
}

