/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.pdc.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.persistence.jdbc.DBUtil;

public class PdcRightsDAO {
    private PdcRightsDAO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getUserIds(Connection con, String axisId, String valueId) throws SQLException {
        ArrayList<String> listUsersIds = new ArrayList<String>();
        String query = "select userId from sb_pdc_user_rights where valueid = ? and axisId = ?";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(valueId));
            prepStmt.setInt(2, Integer.parseInt(axisId));
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                listUsersIds.add(Integer.toString(rs.getInt(1)));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return listUsersIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUserManager(Connection con, String userId) throws SQLException {
        boolean bl;
        String query = "select userId from sb_pdc_user_rights where userid = ? ";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(userId));
            rs = prepStmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGroupManager(Connection con, String[] groupIds) throws SQLException {
        boolean bl;
        if (groupIds == null || groupIds.length == 0) {
            return false;
        }
        StringBuilder clauseIN = new StringBuilder("(");
        boolean firstGroup = true;
        for (String groupId : groupIds) {
            if (!firstGroup) {
                clauseIN.append(",");
            }
            clauseIN.append(groupId);
            firstGroup = false;
        }
        clauseIN.append(")");
        String query = "select groupId from sb_pdc_group_rights where groupid IN " + clauseIN.toString();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            rs = prepStmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getGroupIds(Connection con, String axisId, String valueId) throws SQLException {
        ArrayList<String> listGroupsIds = new ArrayList<String>();
        String query = "select groupid from sb_pdc_group_rights where valueid = ? and axisId = ?";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(valueId));
            prepStmt.setInt(2, Integer.parseInt(axisId));
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                listGroupsIds.add(Integer.toString(rs.getInt(1)));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return listGroupsIds;
    }

    public static void deleteRights(Connection con, String axisId, String valueId) throws SQLException {
        PdcRightsDAO.deleteUserRights(con, axisId, valueId);
        PdcRightsDAO.deleteGroupRights(con, axisId, valueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteUserRights(Connection con, String axisId, String valueId) throws SQLException {
        String query = "delete from sb_pdc_user_rights where valueid = ? and axisId = ?";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(valueId));
            prepStmt.setInt(2, Integer.parseInt(axisId));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteGroupRights(Connection con, String axisId, String valueId) throws SQLException {
        String query = "delete from sb_pdc_group_rights where valueid = ? and axisId = ?";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(valueId));
            prepStmt.setInt(2, Integer.parseInt(axisId));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertUserId(Connection con, String axisId, String valueId, String uid) throws SQLException {
        String query = "insert into sb_pdc_user_rights values (?, ?, ?)";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(axisId));
            prepStmt.setInt(2, Integer.parseInt(valueId));
            prepStmt.setInt(3, Integer.parseInt(uid));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertGroupId(Connection con, String axisId, String valueId, String gid) throws SQLException {
        String query = "insert into sb_pdc_group_rights values (?, ?, ?)";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(axisId));
            prepStmt.setInt(2, Integer.parseInt(valueId));
            prepStmt.setInt(3, Integer.parseInt(gid));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteManager(Connection con, String userId) throws SQLException {
        String query = "delete from sb_pdc_user_rights where userId = ?";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(userId));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteGroupManager(Connection con, String groupId) throws SQLException {
        String query = "delete from sb_pdc_group_rights where groupId = ?";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(groupId));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAxisRights(Connection con, String axisId) throws SQLException {
        String query = "delete from sb_pdc_user_rights where axisId = ? ";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(axisId));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
        query = "delete from sb_pdc_group_rights where axisId = ? ";
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(axisId));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }
}

