/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.pdc.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.silverpeas.core.pdc.pdc.model.AxisHeader;
import org.silverpeas.core.pdc.pdc.model.ClassifyValue;
import org.silverpeas.core.pdc.pdc.model.PdcAxisValuePk;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.model.PdcRuntimeException;
import org.silverpeas.core.pdc.pdc.model.UsedAxis;
import org.silverpeas.core.pdc.pdc.model.Value;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.core.pdc.tree.model.TreeNode;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.kernel.annotation.NonNull;

@Entity
@Table(name="pdcaxisvalue")
@NamedQuery(name="findByAxisId", query="select p from PdcAxisValue p where p.id.axisId = :axisId")
public class PdcAxisValue
extends BasicJpaEntity<PdcAxisValue, PdcAxisValuePk> {
    private static final long serialVersionUID = 2345886411781136417L;
    @Transient
    private transient TreeNode treeNode;
    @Transient
    private transient TreeNodeList treeNodeParents = new TreeNodeList();

    protected PdcAxisValue() {
    }

    public static PdcAxisValue aPdcAxisValueFromTreeNode(TreeNode treeNode) {
        try {
            List<Value> parents = null;
            if (treeNode.hasFather()) {
                PdcManager pdcManager = PdcAxisValue.getPdcManager();
                parents = pdcManager.getFullPath(treeNode.getFatherId(), treeNode.getTreeId());
            }
            return new PdcAxisValue().fromTreeNode(treeNode).withAsTreeNodeParents(parents).inAxisId(treeNode.getTreeId());
        }
        catch (PdcException ex) {
            throw new PdcRuntimeException((Throwable)((Object)ex));
        }
    }

    public static PdcAxisValue aPdcAxisValue(String valueId, String axisId) {
        return (PdcAxisValue)new PdcAxisValue().setId(valueId + ":" + axisId);
    }

    public String getAxisId() {
        return ((PdcAxisValuePk)this.getNativeId()).getAxisId().toString();
    }

    public String getValueId() {
        return ((PdcAxisValuePk)this.getNativeId()).getValueId().toString();
    }

    public Set<PdcAxisValue> getChildValues() {
        try {
            HashSet<PdcAxisValue> children = new HashSet<PdcAxisValue>();
            List<String> childNodeIds = PdcAxisValue.getPdcManager().getDaughterValues(this.getAxisId(), this.getValueId());
            for (String aNodeId : childNodeIds) {
                children.add(PdcAxisValue.aPdcAxisValue(aNodeId, this.getAxisId()));
            }
            return Collections.unmodifiableSet(children);
        }
        catch (PdcException ex) {
            throw new PdcRuntimeException((Throwable)((Object)ex));
        }
    }

    public PdcAxisValue getParentValue() {
        PdcAxisValue parent;
        TreeNode node = this.getTreeNode();
        if (node.hasFather()) {
            int lastNodeIndex = this.treeNodeParents.size() - 1;
            TreeNode aTreeNode = this.treeNodeParents.get(lastNodeIndex);
            String valueId = aTreeNode.getPK().getId();
            String axisId = this.getAxisId();
            PdcAxisValue pdcAxisValue = (PdcAxisValue)new PdcAxisValue().setId(valueId + ":" + axisId);
            parent = pdcAxisValue.fromTreeNode(aTreeNode).inAxisId(this.getAxisId()).withAsTreeNodeParents(this.treeNodeParents.subList(0, lastNodeIndex));
        } else {
            parent = null;
        }
        return parent;
    }

    public String getTerm() {
        return this.getTreeNode().getName();
    }

    public String getTermTranslatedIn(String language) {
        return this.getTreeNode().getName(language);
    }

    public boolean isBaseValue() {
        return this.getTreeNodeParents().size() <= 1;
    }

    public String getMeaning() {
        return this.getMeaningTranslatedIn("");
    }

    public String getMeaningTranslatedIn(String language) {
        String theLanguage = language == null ? "" : language;
        PdcAxisValue theParent = this.getParentValue();
        Object meaning = theParent != null ? theParent.getMeaningTranslatedIn(theLanguage) + " / " : "";
        return (String)meaning + this.getTerm();
    }

    public String getValuePath() {
        return this.getTreeNode().getPath() + this.getValueId();
    }

    protected PdcAxisValue copy() {
        PdcAxisValue copy = PdcAxisValue.aPdcAxisValue(this.getValueId(), this.getAxisId());
        copy.treeNode = this.treeNode;
        copy.treeNodeParents = this.treeNodeParents;
        return copy;
    }

    protected UsedAxis getUsedAxis() {
        try {
            PdcManager pdc = PdcAxisValue.getPdcManager();
            UsedAxis usedAxis = pdc.getUsedAxis(this.getAxisId());
            AxisHeader axisHeader = pdc.getAxisHeader(this.getAxisId());
            usedAxis._setAxisHeader(axisHeader);
            usedAxis._setAxisName(axisHeader.getName());
            return usedAxis;
        }
        catch (PdcException ex) {
            throw new PdcRuntimeException((Throwable)((Object)ex));
        }
    }

    protected TreeNode getTreeNode() {
        if (this.treeNode == null || this.treeNodeParents == null && this.treeNode.hasFather()) {
            this.loadTreeNodes();
        }
        return this.treeNode;
    }

    protected void setId(long id) {
        ((PdcAxisValuePk)this.getNativeId()).setValueId(id);
    }

    protected PdcAxisValue inAxisId(String axisId) {
        ((PdcAxisValuePk)this.getNativeId()).setAxisId(Long.valueOf(axisId));
        return this;
    }

    protected PdcAxisValue fromTreeNode(TreeNode treeNode) {
        ((PdcAxisValuePk)this.getNativeId()).setValueId(Long.valueOf(treeNode.getPK().getId()));
        this.treeNode = treeNode;
        return this;
    }

    protected PdcAxisValue withAsTreeNodeParents(List<? extends TreeNode> parents) {
        this.treeNodeParents.setAll(parents);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PdcAxisValue other = (PdcAxisValue)((Object)obj);
        if (!(Objects.equals(((PdcAxisValuePk)this.getNativeId()).getValueId(), ((PdcAxisValuePk)other.getNativeId()).getValueId()) || ((PdcAxisValuePk)this.getNativeId()).getValueId() != null && ((PdcAxisValuePk)this.getNativeId()).getValueId().equals(((PdcAxisValuePk)other.getNativeId()).getValueId()))) {
            return false;
        }
        return Objects.equals(((PdcAxisValuePk)this.getNativeId()).getAxisId(), ((PdcAxisValuePk)other.getNativeId()).getAxisId()) || ((PdcAxisValuePk)this.getNativeId()).getAxisId() != null && !((PdcAxisValuePk)this.getNativeId()).getAxisId().equals(((PdcAxisValuePk)other.getNativeId()).getAxisId());
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (((PdcAxisValuePk)this.getNativeId()).getValueId() != null ? ((PdcAxisValuePk)this.getNativeId()).getValueId().hashCode() : 0);
        hash = 89 * hash + (((PdcAxisValuePk)this.getNativeId()).getAxisId() != null ? ((PdcAxisValuePk)this.getNativeId()).getAxisId().hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "";
    }

    public ClassifyValue toClassifyValue() {
        ClassifyValue value = new ClassifyValue(Integer.parseInt(this.getAxisId()), this.getValuePath() + "/");
        ArrayList<Value> fullPath = new ArrayList<Value>();
        for (TreeNode aTreeNode : this.getTreeNodeParents()) {
            fullPath.add(new Value(aTreeNode));
        }
        TreeNode lastValue = this.getTreeNode();
        fullPath.add(new Value(lastValue));
        value.setFullPath(fullPath);
        return value;
    }

    private TreeNodeList getTreeNodeParents() {
        if (this.treeNodeParents == null) {
            this.loadTreeNodes();
        }
        return this.treeNodeParents;
    }

    private void loadTreeNodes() {
        try {
            PdcManager pdc = PdcAxisValue.getPdcManager();
            String treeId = pdc.getTreeId(this.getAxisId());
            List<Value> paths = pdc.getFullPath(this.getValueId(), treeId);
            int lastNodeIndex = paths.size() - 1;
            this.treeNode = paths.get(lastNodeIndex);
            this.treeNodeParents.setAll(paths.subList(0, lastNodeIndex));
        }
        catch (PdcException ex) {
            throw new PdcRuntimeException((Throwable)((Object)ex));
        }
    }

    private static PdcManager getPdcManager() {
        return PdcManager.get();
    }

    private static class TreeNodeList
    implements Iterable<TreeNode> {
        private final List<TreeNode> treeNodes = new ArrayList<TreeNode>();

        private TreeNodeList() {
        }

        public int size() {
            return this.treeNodes.size();
        }

        public TreeNode get(int index) {
            return this.treeNodes.get(index);
        }

        public List<TreeNode> subList(int fromIndex, int toIndex) {
            return this.treeNodes.subList(fromIndex, toIndex);
        }

        public void setAll(Collection<? extends TreeNode> nodes) {
            this.treeNodes.clear();
            this.treeNodes.addAll(nodes);
        }

        @Override
        @NonNull
        public Iterator<TreeNode> iterator() {
            return this.treeNodes.iterator();
        }

        @Override
        public void forEach(Consumer<? super TreeNode> action) {
            this.treeNodes.forEach(action);
        }

        @Override
        public Spliterator<TreeNode> spliterator() {
            return this.treeNodes.spliterator();
        }
    }
}

