/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.common;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class ScimUtils {
    private ScimUtils() {
    }

    public static String toDateString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat.format(date);
    }

    public static String toDateTimeString(Date date) {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS");
        return dateTimeFormat.format(date);
    }

    public static String toDateString(LocalDate ld) {
        return ld.format(DateTimeFormatter.ISO_DATE);
    }

    public static String toDateTimeString(LocalDateTime ldt) {
        return ldt.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public static List<Field> getFieldsUpTo(Class<?> startClass, Class<?> exclusiveParent) {
        ArrayList currentClassFields = Lists.newArrayList((Object[])startClass.getDeclaredFields());
        Class<?> parentClass = startClass.getSuperclass();
        if (!(parentClass == null || exclusiveParent != null && parentClass.equals(exclusiveParent))) {
            List<Field> parentClassFields = ScimUtils.getFieldsUpTo(parentClass, exclusiveParent);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }
}

