/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.persistence.datasource.OperationContext;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.workflow.api.TaskManager;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.event.GenericEvent;
import org.silverpeas.core.workflow.api.instance.ActionStatus;
import org.silverpeas.core.workflow.api.instance.Actor;
import org.silverpeas.core.workflow.api.instance.Question;
import org.silverpeas.core.workflow.api.instance.UpdatableHistoryStep;
import org.silverpeas.core.workflow.api.instance.UpdatableProcessInstance;
import org.silverpeas.core.workflow.api.model.Action;
import org.silverpeas.core.workflow.api.model.Consequence;
import org.silverpeas.core.workflow.api.model.Consequences;
import org.silverpeas.core.workflow.api.model.ProcessModel;
import org.silverpeas.core.workflow.api.model.QualifiedUsers;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.api.model.Trigger;
import org.silverpeas.core.workflow.api.task.Task;
import org.silverpeas.core.workflow.engine.WorkflowHub;
import org.silverpeas.core.workflow.external.ExternalAction;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

class WorkflowTools {
    private static final String ADMIN_ID = "0";

    private WorkflowTools() {
    }

    public static boolean processAction(UpdatableProcessInstance instance, GenericEvent event, UpdatableHistoryStep step, boolean unactivateResolvedState) throws WorkflowException {
        ProcessModel model = instance.getProcessModel();
        TaskManager taskManager = WorkflowHub.getTaskManager();
        String[] states = instance.getActiveStates();
        String resolvedStateName = event.getResolvedState() == null ? "" : event.getResolvedState().getName();
        HashMap<String, String> oldActiveStates = new HashMap<String, String>();
        HashMap<String, String> eligibleStates = new HashMap<String, String>();
        WorkflowTools.checkReDoStates(instance, event, states, resolvedStateName);
        WorkflowTools.checkQuestions(instance, resolvedStateName);
        states = WorkflowTools.setEligibleStates(instance, oldActiveStates, eligibleStates);
        try {
            if (event.getDataRecord() != null) {
                instance.saveActionRecord(step, event.getDataRecord());
            }
            if (unactivateResolvedState && event.getResolvedState() != null) {
                eligibleStates.remove(event.getResolvedState().getName());
            }
            Action action = model.getAction(event.getActionName());
            Consequences consequences = action.getConsequences();
            List<Consequence> matchingConsequences = WorkflowTools.getMatchingConsequences(instance, consequences);
            for (Consequence consequence : matchingConsequences) {
                Objects.requireNonNull(consequence);
                SilverLogger.getLogger(WorkflowTools.class).info("Process action {0}: item = {1}, operator = {2}, value = {3}", new Object[]{event.getActionName(), consequence.getItem(), consequence.getOperator(), consequence.getValue()});
                if (consequence.getKill()) {
                    for (String state : states) {
                        WorkflowTools.removeAffectations(instance, model.getState(state));
                    }
                }
                State[] targetStates = consequence.getTargetStates();
                State[] unsetStates = consequence.getUnsetStates();
                WorkflowTools.addStatesToEligibility(eligibleStates, targetStates);
                WorkflowTools.removeStatesFromEligibility(eligibleStates, unsetStates);
                WorkflowTools.processTriggers(consequence, instance, event);
                List<QualifiedUsers> notifiedUsersList = consequence.getNotifiedUsers();
                WorkflowTools.notifyUsers(instance, event, taskManager, action, notifiedUsersList);
            }
        }
        catch (Exception e) {
            step.setActionStatus(ActionStatus.PROCESS_FAILED);
            instance.updateHistoryStep(step);
            throw new WorkflowException("WorkflowEngineThread.process", "workflowEngine.EX_ERR_PROCESS_EVENT", e);
        }
        WorkflowTools.computeStates(instance, event, eligibleStates, oldActiveStates);
        step.setActionStatus(ActionStatus.AFFECTATIONS_DONE);
        instance.updateHistoryStep(step);
        return false;
    }

    private static void notifyUsers(UpdatableProcessInstance instance, GenericEvent event, TaskManager taskManager, Action action, List<QualifiedUsers> notifiedUsersList) throws WorkflowException {
        for (QualifiedUsers notifiedUsers : notifiedUsersList) {
            Actor[] actors = instance.getActors(notifiedUsers, null);
            Task[] tasks = taskManager.createTasks(actors, instance);
            String message = notifiedUsers.getMessage();
            if (StringUtil.isNotDefined((String)message)) {
                message = action.getDescription("", "");
            }
            boolean linkDisabled = notifiedUsers.getLinkDisabled() != null && notifiedUsers.getLinkDisabled() != false;
            String senderId = notifiedUsers.getSenderId();
            org.silverpeas.core.workflow.api.user.User forcedUser = null;
            if (senderId != null) {
                forcedUser = WorkflowTools.getForcedUser(senderId, event.getActionName());
            }
            org.silverpeas.core.workflow.api.user.User sender = forcedUser == null ? event.getUserOrSubstitute() : forcedUser;
            for (int i = 0; i < actors.length; ++i) {
                taskManager.notifyActor(tasks[i], sender, actors[i], message, linkDisabled);
            }
        }
    }

    private static void removeStatesFromEligibility(HashMap<String, String> eligibleStates, State[] unsetStates) {
        for (State unsetState : unsetStates) {
            if (unsetState == null) continue;
            String name = unsetState.getName();
            eligibleStates.remove(name);
        }
    }

    private static void addStatesToEligibility(HashMap<String, String> eligibleStates, State[] targetStates) {
        for (State targetState : targetStates) {
            if (targetState == null) continue;
            String name = targetState.getName();
            eligibleStates.put(name, name);
        }
    }

    private static List<Consequence> getMatchingConsequences(UpdatableProcessInstance instance, Consequences consequences) throws FormException, WorkflowException {
        boolean verified = false;
        ArrayList<Consequence> matchingConsequences = new ArrayList<Consequence>();
        for (Consequence consequence : consequences.getConsequenceList()) {
            if (consequence.getItem() != null) {
                Field fieldToCompare = instance.getFolder().getField(consequence.getItem());
                if (fieldToCompare != null && fieldToCompare.getStringValue() != null) {
                    verified = consequence.isVerified(fieldToCompare.getStringValue());
                }
            } else {
                verified = true;
            }
            if (!verified) continue;
            matchingConsequences.add(consequence);
        }
        return matchingConsequences;
    }

    private static String[] setEligibleStates(UpdatableProcessInstance instance, HashMap<String, String> oldActiveStates, HashMap<String, String> eligibleStates) {
        String[] states;
        for (String state : states = instance.getActiveStates()) {
            eligibleStates.put(state, state);
            oldActiveStates.put(state, state);
        }
        return states;
    }

    private static void checkReDoStates(UpdatableProcessInstance instance, GenericEvent event, String[] states, String resolvedStateName) throws WorkflowException {
        boolean backStatus = event.getResolvedState() != null && instance.isStateInBackStatus(resolvedStateName);
        for (int i = 0; backStatus && i < states.length; ++i) {
            if (!states[i].equals(resolvedStateName)) continue;
            instance.reDoState(resolvedStateName, event.getActionDate());
        }
    }

    private static void processTriggers(Consequence consequence, UpdatableProcessInstance instance, GenericEvent event) {
        if (consequence != null) {
            Iterator<Trigger> triggers = consequence.getTriggers().iterateTrigger();
            while (triggers.hasNext()) {
                CacheAccessorProvider.getThreadCacheAccessor().getCache().clear();
                Trigger trigger = triggers.next();
                if (trigger == null) continue;
                try {
                    WorkflowTools.setUpOperationContext(event);
                    ExternalAction externalAction = (ExternalAction)ServiceProvider.getService((String)trigger.getHandler());
                    externalAction.setProcessInstance(instance);
                    externalAction.setEvent(event);
                    externalAction.setTrigger(trigger);
                    externalAction.execute();
                }
                catch (Exception e) {
                    SilverLogger.getLogger(WorkflowTools.class).error("Error while processing triggers: action = {0}, trigger = {1}", (Object[])new String[]{event.getActionName(), trigger.getName()}, (Throwable)e);
                }
            }
        }
    }

    private static void setUpOperationContext(GenericEvent event) {
        String currentUserId = ADMIN_ID;
        if (event.getUser() != null) {
            currentUserId = event.getUser().getUserId();
        }
        OperationContext.fromUser((User)User.getById((String)currentUserId));
    }

    private static void computeStates(UpdatableProcessInstance instance, GenericEvent event, HashMap<String, String> eligibleStates, HashMap<String, String> oldActiveStates) throws WorkflowException {
        State[] states;
        ProcessModel model = instance.getProcessModel();
        for (State state : states = model.getStates()) {
            boolean eligible = eligibleStates.containsKey(state.getName());
            if (eligible) {
                instance.addActiveState(state);
                if (oldActiveStates.containsKey(state.getName())) {
                    WorkflowTools.removeAffectations(instance, state);
                }
                WorkflowTools.computeAffectations(instance, event, state);
                continue;
            }
            if (!oldActiveStates.containsKey(state.getName())) continue;
            instance.removeActiveState(state);
            WorkflowTools.removeAffectations(instance, state);
        }
    }

    private static void computeAffectations(UpdatableProcessInstance instance, GenericEvent event, State state) throws WorkflowException {
        TaskManager taskManager = WorkflowHub.getTaskManager();
        QualifiedUsers wkUsers = state.getWorkingUsers();
        Actor[] actors = instance.getActors(wkUsers, state);
        if (event.getUser() != null) {
            Object[] tasks;
            Object[] objectArray = tasks = taskManager.createTasks(actors, instance);
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object task = objectArray[i];
                taskManager.assignTask((Task)task, event.getUser());
            }
        }
        for (Actor actor : actors) {
            instance.addWorkingUser(actor, state);
        }
        QualifiedUsers intUsers = state.getInterestedUsers();
        for (Actor actor : actors = instance.getActors(intUsers, state)) {
            instance.addInterestedUser(actor, state);
        }
    }

    private static void removeAffectations(UpdatableProcessInstance instance, State state) throws WorkflowException {
        Task[] tasks;
        TaskManager taskManager = WorkflowHub.getTaskManager();
        Actor[] actors = instance.getWorkingUsers(state.getName());
        for (Task task : tasks = taskManager.createTasks(actors, instance)) {
            taskManager.unAssignTask(task);
        }
        instance.removeInterestedUsers(state);
        instance.removeWorkingUsers(state);
    }

    private static void checkQuestions(UpdatableProcessInstance instance, String resolvedStateName) throws WorkflowException {
        Question[] questions = instance.getSentQuestions(resolvedStateName);
        for (int i = 0; questions != null && i < questions.length; ++i) {
            instance.cancelQuestion(questions[i]);
        }
    }

    private static org.silverpeas.core.workflow.api.user.User getForcedUser(String senderId, String actionName) {
        try {
            return WorkflowHub.getUserManager().getUser(senderId);
        }
        catch (WorkflowException we) {
            SilverLogger.getLogger(WorkflowTools.class).error("Error while processing {0}: impossible to find the sender with id {1}", new Object[]{actionName, senderId, we});
            return null;
        }
    }
}

