/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.query.fulltext;

import org.apache.jackrabbit.oak.json.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorQuery {
    private static final Logger LOG = LoggerFactory.getLogger(VectorQuery.class);
    private static final String DEFAULT_INFERENCE_QUERY_CONFIG_PREFIX = "?";
    public static final String INFERENCE_QUERY_CONFIG_PREFIX_KEY = "org.apache.jackrabbit.oak.search.inference.query.prefix";
    public static final String INFERENCE_QUERY_CONFIG_PREFIX = System.getProperty("org.apache.jackrabbit.oak.search.inference.query.prefix", "?");
    public static final String EXPERIMENTAL_COMPATIBILITY_MODE_KEY = "oak.inference.experimental.compatibility";
    private static boolean isCompatibilityModeEnabled = Boolean.getBoolean("oak.inference.experimental.compatibility");
    private final String queryInferenceConfig;
    private final String queryText;

    public VectorQuery(@NotNull String text) {
        String[] components = this.parseText(text);
        this.queryInferenceConfig = components[0];
        this.queryText = components[1];
    }

    private String[] parseText(String inputText) {
        String jsonPart = null;
        String queryTextPart = null;
        String text = inputText.trim();
        if (text.startsWith(INFERENCE_QUERY_CONFIG_PREFIX)) {
            if ((text = text.substring(INFERENCE_QUERY_CONFIG_PREFIX.length())).charAt(0) == '{') {
                int possibleEndIndex = 0;
                int jsonEndDelimiterIndex = -1;
                while (possibleEndIndex < text.length()) {
                    if ((possibleEndIndex = text.indexOf(INFERENCE_QUERY_CONFIG_PREFIX, possibleEndIndex + INFERENCE_QUERY_CONFIG_PREFIX.length())) == -1) {
                        jsonPart = "{}";
                        jsonEndDelimiterIndex = 0;
                        break;
                    }
                    String candidateJson = text.substring(0, possibleEndIndex);
                    if (!JsonUtils.isValidJson((String)candidateJson, (boolean)false)) continue;
                    jsonPart = candidateJson;
                    jsonEndDelimiterIndex = possibleEndIndex;
                    break;
                }
                if ((text = text.substring(jsonEndDelimiterIndex)).startsWith(INFERENCE_QUERY_CONFIG_PREFIX)) {
                    text = text.substring(INFERENCE_QUERY_CONFIG_PREFIX.length());
                }
                queryTextPart = text;
            } else if (isCompatibilityModeEnabled) {
                jsonPart = "{}";
                queryTextPart = text;
            } else {
                jsonPart = "";
                queryTextPart = inputText;
            }
        } else {
            jsonPart = "";
            queryTextPart = text;
        }
        return new String[]{jsonPart, queryTextPart};
    }

    public String getQueryInferenceConfig() {
        return this.queryInferenceConfig;
    }

    public String getQueryText() {
        return this.queryText;
    }

    protected static void reInitializeCompatibilityMode() {
        isCompatibilityModeEnabled = Boolean.getBoolean(EXPERIMENTAL_COMPATIBILITY_MODE_KEY);
    }
}

