/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.namepath;

import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.util.XMLChar;

public final class JcrNameParser {
    private static final int STATE_PREFIX_START = 0;
    private static final int STATE_PREFIX = 1;
    private static final int STATE_NAME_START = 2;
    private static final int STATE_NAME = 3;
    private static final int STATE_URI_START = 4;
    private static final int STATE_URI = 5;

    private JcrNameParser() {
    }

    public static boolean parse(String jcrName, Listener listener, int index) {
        int len;
        int n = len = jcrName == null ? 0 : jcrName.length();
        if (len == 0) {
            listener.error("Empty name.");
            return false;
        }
        if (".".equals(jcrName) || "..".equals(jcrName)) {
            listener.error("Illegal name:" + jcrName);
            return false;
        }
        int nameStart = 0;
        int state = 0;
        for (int i = 0; i < len; ++i) {
            char c = jcrName.charAt(i);
            if (c == ':') {
                if (state == 0) {
                    listener.error("Prefix must not be empty.");
                    return false;
                }
                if (state == 1) {
                    String prefix = jcrName.substring(0, i);
                    if (!XMLChar.isValidNCName((String)prefix)) {
                        listener.error("Invalid name prefix: " + prefix);
                        return false;
                    }
                    state = 2;
                    continue;
                }
                if (state == 5) continue;
                listener.error("'" + c + "' not allowed in name.");
                return false;
            }
            if (c == '[' || c == ']' || c == '*' || c == '|') {
                listener.error("'" + c + "' not allowed in name.");
                return false;
            }
            if (c == '/') {
                if (state == 4) {
                    state = 5;
                    continue;
                }
                if (state == 5) continue;
                listener.error("'" + c + "' not allowed in name.");
                return false;
            }
            if (c == '{') {
                if (state == 0) {
                    state = 4;
                    continue;
                }
                if (state == 4 || state == 5) {
                    state = 3;
                    nameStart = 0;
                    continue;
                }
                if (state != 2) continue;
                state = 3;
                nameStart = i;
                continue;
            }
            if (c == '}') {
                if (state == 4 || state == 5) {
                    String tmp = jcrName.substring(1, i);
                    if (tmp.isEmpty() || tmp.indexOf(58) != -1) {
                        state = 2;
                        continue;
                    }
                    if (tmp.equals("internal")) {
                        state = 2;
                        continue;
                    }
                    if (tmp.indexOf(47) == -1) {
                        state = 3;
                        nameStart = 0;
                        continue;
                    }
                    listener.error("The URI prefix of the name " + jcrName + " is neither a valid URI nor a valid part of a local name.");
                    return false;
                }
                if (state == 0) {
                    state = 1;
                    continue;
                }
                if (state != 2) continue;
                state = 3;
                nameStart = i;
                continue;
            }
            if (state == 0) {
                state = 1;
                continue;
            }
            if (state == 2) {
                state = 3;
                nameStart = i;
                continue;
            }
            if (state != 4) continue;
            state = 5;
        }
        if (state == 5 && (jcrName.indexOf(58) > -1 || jcrName.indexOf(47) > -1)) {
            listener.error("Local name may not contain ':' nor '/'.");
            return false;
        }
        if (nameStart == len || state == 2) {
            listener.error("Local name must not be empty.");
            return false;
        }
        return listener.name(jcrName, index);
    }

    public static boolean validate(String jcrName) {
        Listener listener = new Listener(){

            @Override
            public void error(String message) {
            }

            @Override
            public boolean name(String name, int index) {
                return true;
            }
        };
        return JcrNameParser.parse(jcrName, listener, 0);
    }

    public static void checkName(String jcrName, boolean allowResidual) throws ConstraintViolationException {
        if (!(jcrName != null && (allowResidual && "*".equals(jcrName) || JcrNameParser.validate(jcrName)))) {
            throw new ConstraintViolationException("Not a valid JCR name '" + jcrName + "'");
        }
    }

    static interface Listener {
        public void error(String var1);

        public boolean name(String var1, int var2);
    }
}

