/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist.service.model.dao;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.transaction.Transactional;
import org.silverpeas.components.mailinglist.service.model.beans.Activity;
import org.silverpeas.components.mailinglist.service.model.beans.Attachment;
import org.silverpeas.components.mailinglist.service.model.beans.Message;
import org.silverpeas.components.mailinglist.service.model.dao.MessageDao;
import org.silverpeas.components.mailinglist.service.util.OrderBy;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.security.encryption.cipher.CryptMD5;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Repository
@Named(value="messageDao")
@Transactional
public class MessageDaoImpl
implements MessageDao {
    private static final String COMPONENT_ID = "componentId";
    private static final String MODERATED = "moderated";
    @PersistenceContext
    private EntityManager entityManager;

    private EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public String saveMessage(Message message) {
        Message existingMessage = this.findMessageByMailId(message.getMessageId(), message.getComponentId());
        if (existingMessage == null) {
            if (message.getAttachments() != null && !message.getAttachments().isEmpty()) {
                for (Attachment attachment : message.getAttachments()) {
                    this.saveAttachmentFile(attachment);
                }
            }
            this.getEntityManager().persist((Object)message);
            return message.getId();
        }
        return existingMessage.getId();
    }

    @Override
    public void updateMessage(Message message) {
        this.getEntityManager().merge((Object)message);
    }

    @Override
    public void deleteMessage(Message message) {
        EntityManager theEntityManager = this.getEntityManager();
        Message reattachedMessage = (Message)theEntityManager.merge((Object)message);
        if (message.getAttachments() != null && !message.getAttachments().isEmpty()) {
            for (Attachment attachment : message.getAttachments()) {
                this.deleteAttachmentFile(attachment);
            }
        }
        theEntityManager.remove((Object)reattachedMessage);
    }

    @Override
    public Message findMessageById(String id) {
        return (Message)this.getEntityManager().find(Message.class, (Object)id);
    }

    public Message findMessageByMailId(String messageId, String componentId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("findMessage", Message.class);
        query.setParameter(COMPONENT_ID, (Object)componentId);
        query.setParameter("messageId", (Object)messageId);
        Message result = null;
        try {
            result = (Message)query.getSingleResult();
        }
        catch (NoResultException ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    @Override
    public List<Message> listAllMessagesOfMailingList(String componentId, int page, int elementsPerPage, OrderBy orderBy) {
        TypedQuery query = this.getEntityManager().createQuery("select m from Message m where m.componentId = :componentId " + orderBy.getOrderExpression(), Message.class);
        query.setParameter(COMPONENT_ID, (Object)componentId);
        query.setFirstResult(page * elementsPerPage);
        query.setMaxResults(elementsPerPage);
        return query.getResultList();
    }

    @Override
    public List<Message> listDisplayableMessagesOfMailingList(String componentId, int month, int year, int page, int elementsPerPage, OrderBy orderBy) {
        Object queryText = "select m from Message m where m.componentId = :componentId and m.moderated = :moderated";
        if (month >= 0) {
            queryText = (String)queryText + " and month = " + month;
        }
        if (year >= 0) {
            queryText = (String)queryText + " and year = " + year;
        }
        queryText = (String)queryText + " " + orderBy.getOrderExpression();
        TypedQuery query = this.getEntityManager().createQuery((String)queryText, Message.class);
        query.setParameter(COMPONENT_ID, (Object)componentId);
        query.setParameter(MODERATED, (Object)true);
        query.setFirstResult(page * elementsPerPage);
        query.setMaxResults(elementsPerPage);
        return query.getResultList();
    }

    @Override
    public List<Message> listUnmoderatedMessagesOfMailingList(String componentId, int page, int elementsPerPage, OrderBy orderBy) {
        TypedQuery query = this.getEntityManager().createQuery("select m from Message m where m.componentId = :componentId and m.moderated = :moderated " + orderBy.getOrderExpression(), Message.class);
        query.setParameter(COMPONENT_ID, (Object)componentId);
        query.setParameter(MODERATED, (Object)false);
        query.setFirstResult(page * elementsPerPage);
        query.setMaxResults(elementsPerPage);
        return query.getResultList();
    }

    @Override
    public List<Message> listActivityMessages(String componentId, int size, OrderBy orderBy) {
        TypedQuery query = this.getEntityManager().createQuery("select m from Message m where m.componentId = :componentId and m.moderated = :moderated " + orderBy.getOrderExpression(), Message.class);
        query.setParameter(COMPONENT_ID, (Object)componentId);
        query.setParameter(MODERATED, (Object)true);
        query.setMaxResults(size);
        return query.getResultList();
    }

    @Override
    public long listTotalNumberOfMessages(String componentId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("countOfMessages", Long.class);
        query.setParameter(COMPONENT_ID, (Object)componentId);
        return (Long)query.getSingleResult();
    }

    @Override
    public long listTotalNumberOfDisplayableMessages(String componentId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("countOfMessagesByModeration", Long.class);
        query.setParameter(COMPONENT_ID, (Object)componentId);
        query.setParameter(MODERATED, (Object)true);
        return (Long)query.getSingleResult();
    }

    @Override
    public long listTotalNumberOfUnmoderatedMessages(String componentId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("countOfMessagesByModeration", Long.class);
        query.setParameter(COMPONENT_ID, (Object)componentId);
        query.setParameter(MODERATED, (Object)false);
        return (Long)query.getSingleResult();
    }

    @Override
    public List<Activity> listActivity(String componentId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("findActivitiesFromMessages", Activity.class);
        query.setParameter(COMPONENT_ID, (Object)componentId);
        query.setParameter(MODERATED, (Object)true);
        return query.getResultList();
    }

    protected void saveAttachmentFile(Attachment attachment) {
        try {
            File file = new File(attachment.getPath());
            if (file.exists() && file.isFile()) {
                attachment.setSize(file.length());
                String hash = CryptMD5.encrypt((File)file);
                attachment.setMd5Signature(hash);
                Attachment existingFile = this.findAlreadyExistingAttachment(hash, file.length(), attachment.getFileName(), null);
                if (existingFile != null && !existingFile.getPath().equals(attachment.getPath())) {
                    attachment.setPath(existingFile.getPath());
                    this.deleteFile(file);
                }
            }
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void deleteAttachmentFile(Attachment attachment) {
        Attachment existingFile;
        File file = new File(attachment.getPath());
        if (file.exists() && file.isFile() && (existingFile = this.findAlreadyExistingAttachment(attachment.getMd5Signature(), attachment.getSize(), attachment.getFileName(), attachment.getId())) == null) {
            this.deleteFile(file);
        }
    }

    protected Attachment findAlreadyExistingAttachment(String md5Hash, long size, String fileName, String attachmentId) {
        TypedQuery query;
        if (StringUtil.isDefined((String)attachmentId)) {
            query = this.getEntityManager().createNamedQuery("findSomeAttachmentsExcludingOne", Attachment.class);
            query.setParameter("id", (Object)attachmentId);
        } else {
            query = this.getEntityManager().createNamedQuery("findSomeAttachments", Attachment.class);
        }
        query.setParameter("md5", (Object)md5Hash);
        query.setParameter("size", (Object)size);
        query.setParameter("fileName", (Object)fileName);
        List attachments = query.getResultList();
        Attachment result = null;
        if (!attachments.isEmpty()) {
            result = (Attachment)attachments.get(0);
        }
        return result;
    }

    private void deleteFile(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)this).warn("Cannot delete file {0}", new Object[]{file.getPath()});
        }
    }
}

